/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.service;

import com.tencent.common.Configure;
import com.tencent.common.Log;
import com.tencent.common.Signature;
import com.tencent.common.Util;
import com.tencent.protocol.close_protocol.CloseReqData;
import com.tencent.protocol.close_protocol.CloseResData;
import com.tencent.service.BaseService;
import org.slf4j.LoggerFactory;

public class CloseService
extends BaseService {
    private static Log log = new Log(LoggerFactory.getLogger(CloseService.class));

    public CloseService() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        super(Configure.CLOSE_API);
    }

    public String request(CloseReqData closeReqData) throws Exception {
        String responseString = this.sendPost(closeReqData);
        return responseString;
    }

    public CloseResData close(String outTradeNo) throws Exception {
        CloseResData closeResData = null;
        CloseReqData reqData = new CloseReqData(outTradeNo);
        long costTimeStart = System.currentTimeMillis();
        log.i("\u5173\u95ed\u5b9a\u5355API\u8fd4\u56de\u7684\u6570\u636e\u5982\u4e0b\uff1a");
        String responseString = this.sendPost(reqData);
        System.err.println("responseString : " + responseString);
        long costTimeEnd = System.currentTimeMillis();
        long totalTimeCost = costTimeEnd - costTimeStart;
        log.i("api\u8bf7\u6c42\u603b\u8017\u65f6\uff1a" + totalTimeCost + "ms");
        log.i(responseString);
        closeResData = (CloseResData)Util.getObjectFromXML(responseString, CloseResData.class);
        if (closeResData == null || closeResData.getReturn_code() == null) {
            log.e("\u3010\u5173\u95ed\u5b9a\u5355\u5931\u8d25\u3011\u5173\u95ed\u5b9a\u5355\u8bf7\u6c42\u903b\u8f91\u9519\u8bef\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u6d4b\u4f20\u8fc7\u53bb\u7684\u6bcf\u4e00\u4e2a\u53c2\u6570\u662f\u5426\u5408\u6cd5\uff0c\u6216\u662f\u770bAPI\u80fd\u5426\u88ab\u6b63\u5e38\u8bbf\u95ee");
            return closeResData;
        }
        if (closeResData.getReturn_code().equals("FAIL")) {
            log.e("\u3010\u5173\u95ed\u5b9a\u5355\u5931\u8d25\u3011\u5173\u95ed\u5b9a\u5355API\u7cfb\u7edf\u8fd4\u56de\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4bPost\u7ed9API\u7684\u6570\u636e\u662f\u5426\u89c4\u8303\u5408\u6cd5, err_code:" + closeResData.getErr_code() + ", err_des:" + closeResData.getErr_code_des());
            return closeResData;
        }
        log.i("\u5173\u95ed\u5b9a\u5355API\u7cfb\u7edf\u6210\u529f\u8fd4\u56de\u6570\u636e");
        if (!Signature.checkIsSignValidFromResponseString(responseString)) {
            log.e("\u3010\u5173\u95ed\u5b9a\u5355\u5931\u8d25\u3011\u5173\u95ed\u5b9a\u5355\u8bf7\u6c42API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u6709\u53ef\u80fd\u6570\u636e\u88ab\u7be1\u6539\u4e86");
            return closeResData;
        }
        String errorCode = closeResData.getErr_code();
        String errorCodeDes = closeResData.getErr_code_des();
        if (closeResData.getResult_code().equals("SUCCESS")) {
            log.i("\u3010\u5173\u95ed\u5b9a\u5355\u6210\u529f\u3011");
            return closeResData;
        }
        log.i("\u4e1a\u52a1\u8fd4\u56de\u5931\u8d25");
        log.i("err_code:" + errorCode);
        log.i("err_code_des:" + errorCodeDes);
        log.e("\u3010\u5173\u95ed\u5b9a\u5355\u660e\u786e\u5931\u8d25\u3011\u539f\u56e0\u662f\uff1a" + errorCodeDes);
        return closeResData;
    }
}

