/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.service;

import com.tencent.common.Configure;
import com.tencent.common.Log;
import com.tencent.common.Signature;
import com.tencent.common.Util;
import com.tencent.protocol.unified_protocol.UnifiedOutData;
import com.tencent.protocol.unified_protocol.UnifiedReqData;
import com.tencent.protocol.unified_protocol.UnifiedResData;
import com.tencent.service.BaseService;
import org.slf4j.LoggerFactory;

public class UnifiedService
extends BaseService {
    private static Log log = new Log(LoggerFactory.getLogger(UnifiedService.class));

    public UnifiedService() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        super(Configure.UNIFIED_API);
    }

    public String request(UnifiedReqData unifiedReqData) throws Exception {
        String responseString = this.sendPost(unifiedReqData);
        return responseString;
    }

    public UnifiedOutData appUnified(String body, String outTradeNo, int totalFee, String spBillCreateIP, String timeStart, String timeExpire, String notifyUrl, String productId) throws Exception {
        UnifiedOutData unifiedOutData = null;
        UnifiedReqData unifiedReqData = new UnifiedReqData(body, "", "", outTradeNo, totalFee, "", spBillCreateIP, timeStart, timeExpire, "", notifyUrl, "APP", productId, "");
        long costTimeStart = System.currentTimeMillis();
        log.i("\u4e0b\u5355API\u8fd4\u56de\u7684\u6570\u636e\u5982\u4e0b\uff1a");
        String unifiedResponseString = this.request(unifiedReqData);
        System.err.println("unifiedResponseString : " + unifiedResponseString);
        long costTimeEnd = System.currentTimeMillis();
        long totalTimeCost = costTimeEnd - costTimeStart;
        log.i("api\u8bf7\u6c42\u603b\u8017\u65f6\uff1a" + totalTimeCost + "ms");
        log.i(unifiedResponseString);
        UnifiedResData unifiedResData = (UnifiedResData)Util.getObjectFromXML(unifiedResponseString, UnifiedResData.class);
        if (unifiedResData == null || unifiedResData.getReturn_code() == null) {
            log.e("\u3010\u4e0b\u5355\u5931\u8d25\u3011\u4e0b\u5355\u8bf7\u6c42\u903b\u8f91\u9519\u8bef\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u6d4b\u4f20\u8fc7\u53bb\u7684\u6bcf\u4e00\u4e2a\u53c2\u6570\u662f\u5426\u5408\u6cd5\uff0c\u6216\u662f\u770bAPI\u80fd\u5426\u88ab\u6b63\u5e38\u8bbf\u95ee");
            return unifiedOutData;
        }
        if (unifiedResData.getReturn_code().equals("FAIL")) {
            log.e("\u3010\u4e0b\u5355\u5931\u8d25\u3011\u4e0b\u5355API\u7cfb\u7edf\u8fd4\u56de\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4bPost\u7ed9API\u7684\u6570\u636e\u662f\u5426\u89c4\u8303\u5408\u6cd5, err_code:" + unifiedResData.getErr_code() + ", err_des:" + unifiedResData.getErr_code_des());
            return unifiedOutData;
        }
        log.i("\u4e0b\u5355API\u7cfb\u7edf\u6210\u529f\u8fd4\u56de\u6570\u636e");
        if (!Signature.checkIsSignValidFromResponseString(unifiedResponseString)) {
            log.e("\u3010\u4e0b\u5355\u5931\u8d25\u3011\u4e0b\u5355\u8bf7\u6c42API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u6709\u53ef\u80fd\u6570\u636e\u88ab\u7be1\u6539\u4e86");
            return unifiedOutData;
        }
        String errorCode = unifiedResData.getErr_code();
        String errorCodeDes = unifiedResData.getErr_code_des();
        if (unifiedResData.getResult_code().equals("SUCCESS")) {
            log.i("\u3010\u4e00\u6b21\u6027\u4e0b\u5355\u6210\u529f\u3011");
            unifiedOutData = new UnifiedOutData(unifiedResData);
            log.i("out_json:" + unifiedOutData.toJson());
            return unifiedOutData;
        }
        log.i("\u4e1a\u52a1\u8fd4\u56de\u5931\u8d25");
        log.i("err_code:" + errorCode);
        log.i("err_code_des:" + errorCodeDes);
        log.w("\u3010\u4e0b\u5355\u660e\u786e\u5931\u8d25\u3011\u539f\u56e0\u662f\uff1a" + errorCodeDes);
        return unifiedOutData;
    }
}

