/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.AsrRequest;
import com.tencent.asr.model.AsrResponse;
import com.tencent.asr.service.HttpBaseService;
import com.tencent.asr.service.SpeechRecognizer;
import com.tencent.asr.utils.AsrUtils;
import com.tencent.core.handler.BaseEventListener;
import com.tencent.core.handler.RealTimeEventListener;
import com.tencent.core.service.ReportService;
import com.tencent.core.service.TCall;
import com.tencent.core.utils.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;

public class HttpStreamService
extends HttpBaseService
implements TCall<InputStream>,
SpeechRecognizer {
    public HttpStreamService(String streamId, AsrConfig config, AsrRequest request, RealTimeEventListener realTimeEventListener, ExecutorService executor, BaseEventListener<AsrResponse> baseEventListener) {
        super(streamId, config, request, realTimeEventListener, baseEventListener);
    }

    @Override
    public void start() {
        this.tractionManager.beginTraction(this.streamId);
        this.startListerResult();
    }

    @Override
    public void after() {
        this.tractionManager.endTraction(this.streamId);
    }

    @Override
    public Boolean end() {
        return this.stop();
    }

    @Override
    public TCall execute(InputStream stream) throws IOException {
        return this;
    }

    @Override
    public Boolean stop() {
        ReportService.ifLogMessage(this.staging.getStreamId(), "speech end", false);
        if (!this.endFlag.get()) {
            this.endFlag.set(true);
        }
        this.after();
        return this.finishFlag.get();
    }

    @Override
    public void write(byte[] stream) {
    }

    public void write(final InputStream stream) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpStreamService.this.expireTime = System.currentTimeMillis() + HttpStreamService.this.asrConfig.getWaitTime() / 2L;
                boolean end = false;
                while (!HttpStreamService.this.finishFlag.get()) {
                    int len = stream.available();
                    if (!HttpStreamService.this.endFlag.get() && len <= 0) {
                        Thread.sleep(5L);
                        continue;
                    }
                    byte[] data = new byte[HttpStreamService.this.asrRequest.getCutLength().intValue()];
                    if (HttpStreamService.this.endFlag.get() && (len <= 0 || len < HttpStreamService.this.asrRequest.getCutLength())) {
                        HttpStreamService.this.finishFlag.set(true);
                        end = true;
                    }
                    int size = 0;
                    if (len > 0) {
                        size = stream.read(data);
                    }
                    data = HttpStreamService.this.createBytes(data, size);
                    ReportService.ifLogMessage(HttpStreamService.this.staging.getVoiceId(), "read data length:" + data.length, false);
                    if (HttpStreamService.this.cacheStatus || System.currentTimeMillis() > HttpStreamService.this.expireTime) {
                        1 var5_6 = this;
                        synchronized (var5_6) {
                            HttpStreamService.this.cacheStatus = false;
                            HttpStreamService.this.staging.setVoiceId(AsrUtils.getVoiceId(HttpStreamService.this.asrConfig.getAppId()));
                            HttpStreamService.this.staging.setEnd(0);
                            HttpStreamService.this.staging.setSeq(0);
                            ReportService.ifLogMessage(HttpStreamService.this.staging.getVoiceId(), "Retransmission settings:" + JsonUtil.toJson(HttpStreamService.this.staging) + ",\u8fdb\u884cseq=0\u91cd\u4f20", true);
                        }
                    }
                    HttpStreamService.this.expireTime = System.currentTimeMillis() + HttpStreamService.this.asrConfig.getWaitTime();
                    ReportService.ifLogMessage(HttpStreamService.this.staging.getVoiceId(), "dispatcher", false);
                    String stamp = HttpStreamService.this.dispatcherRequest(data, end);
                    HttpStreamService.this.requestStamps.add(stamp);
                    if (!HttpStreamService.this.finishFlag.get() || stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }).start();
    }
}

