/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoBinaryB64LineRecordReader;
import com.twitter.elephantbird.mapreduce.input.LzoBinaryBlockRecordReader;
import com.twitter.elephantbird.mapreduce.input.LzoInputFormat;
import com.twitter.elephantbird.mapreduce.input.LzoProtobufB64LineRecordReader;
import com.twitter.elephantbird.mapreduce.input.LzoProtobufBlockRecordReader;
import com.twitter.elephantbird.mapreduce.input.LzoThriftB64LineRecordReader;
import com.twitter.elephantbird.mapreduce.input.LzoThriftBlockRecordReader;
import com.twitter.elephantbird.mapreduce.io.BinaryBlockReader;
import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.mapreduce.io.IdentityBinaryConverter;
import com.twitter.elephantbird.mapreduce.io.RawBytesWritable;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class MultiInputFormat<M>
extends LzoInputFormat<LongWritable, BinaryWritable<M>> {
    private static String CLASS_CONF_KEY = "elephantbird.class.for.MultiInputFormat";
    private TypeRef<M> typeRef;

    public MultiInputFormat() {
    }

    public MultiInputFormat(TypeRef<M> typeRef) {
        this.typeRef = typeRef;
    }

    public static void setInputFormatClass(Class<?> clazz, Job job) {
        job.setInputFormatClass(MultiInputFormat.class);
        MultiInputFormat.setClassConf(clazz, HadoopCompat.getConfiguration((JobContext)job));
    }

    public static void setClassConf(Class<?> clazz, Configuration conf) {
        HadoopUtils.setClassConf(conf, CLASS_CONF_KEY, clazz);
    }

    public RecordReader<LongWritable, BinaryWritable<M>> createRecordReader(InputSplit split, TaskAttemptContext taskAttempt) throws IOException, InterruptedException {
        Configuration conf = HadoopCompat.getConfiguration((JobContext)taskAttempt);
        if (this.typeRef == null) {
            this.setTypeRef(conf);
        }
        Class<M> recordClass = this.typeRef.getRawClass();
        Format fileFormat = MultiInputFormat.determineFileFormat(split, conf);
        if (MultiInputFormat.isSubclass(recordClass, "com.google.protobuf.Message")) {
            switch (fileFormat) {
                case LZO_BLOCK: {
                    return new LzoProtobufBlockRecordReader<M>(this.typeRef);
                }
                case LZO_B64LINE: {
                    return new LzoProtobufB64LineRecordReader<M>(this.typeRef);
                }
            }
        }
        if (MultiInputFormat.isSubclass(recordClass, "org.apache.thrift.TBase")) {
            switch (fileFormat) {
                case LZO_BLOCK: {
                    return new LzoThriftBlockRecordReader<M>(this.typeRef);
                }
                case LZO_B64LINE: {
                    return new LzoThriftB64LineRecordReader<M>(this.typeRef);
                }
            }
        }
        if (recordClass.equals(byte[].class)) {
            switch (fileFormat) {
                case LZO_BLOCK: {
                    return new LzoBinaryBlockRecordReader(this.typeRef, new BinaryBlockReader<byte[]>(null, (BinaryConverter)new IdentityBinaryConverter()){}, new RawBytesWritable()){};
                }
                case LZO_B64LINE: {
                    return new LzoBinaryB64LineRecordReader<byte[], RawBytesWritable>(this.typeRef, new RawBytesWritable(), new IdentityBinaryConverter());
                }
            }
        }
        throw new IOException("could not determine reader for " + ((FileSplit)split).getPath() + " with class " + recordClass.getName());
    }

    private void setTypeRef(Configuration conf) {
        String className = conf.get(CLASS_CONF_KEY);
        if (className == null) {
            throw new RuntimeException(CLASS_CONF_KEY + " is not set");
        }
        Class clazz = null;
        try {
            clazz = conf.getClassByName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("failed to instantiate class '" + className + "'", e);
        }
        this.typeRef = new TypeRef<M>(clazz){};
    }

    private static boolean isSubclass(Class<?> subClass, String superClassName) {
        try {
            Class<?> superClass = Class.forName(superClassName, true, subClass.getClassLoader());
            return superClass.isAssignableFrom(subClass);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Format determineFileFormat(InputSplit split, Configuration conf) throws IOException {
        FileSplit fileSplit = (FileSplit)split;
        Path file = fileSplit.getPath();
        CompressionCodec codec = new CompressionCodecFactory(conf).getCodec(file);
        if (codec == null) {
            throw new IOException("No codec for file " + file + " found");
        }
        FSDataInputStream in = file.getFileSystem(conf).open(file);
        CompressionInputStream lzoIn = null;
        try {
            lzoIn = codec.createInputStream((InputStream)in);
            for (byte magic : Protobufs.KNOWN_GOOD_POSITION_MARKER) {
                int b = lzoIn.read();
                if (b >= 0 && (byte)b == magic) continue;
                Format format = Format.LZO_B64LINE;
                return format;
            }
        }
        finally {
            IOUtils.closeStream((Closeable)lzoIn);
            IOUtils.closeStream((Closeable)in);
        }
        return Format.LZO_BLOCK;
    }

    private static enum Format {
        LZO_BLOCK,
        LZO_B64LINE;

    }
}

