/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.thrift;

import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.transport.TTransport;

public class ThriftBinaryProtocol
extends TBinaryProtocol {
    public ThriftBinaryProtocol(TTransport trans) {
        super(trans);
    }

    public static void checkContainerElemType(byte type) throws TException {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw new TException("Unexpected type " + type + " in a container");
            }
        }
    }

    public TMap readMapBegin() throws TException {
        TMap map = super.readMapBegin();
        ThriftBinaryProtocol.checkContainerElemType(map.keyType);
        ThriftBinaryProtocol.checkContainerElemType(map.valueType);
        return map;
    }

    public TList readListBegin() throws TException {
        TList list = super.readListBegin();
        ThriftBinaryProtocol.checkContainerElemType(list.elemType);
        return list;
    }

    public TSet readSetBegin() throws TException {
        TSet set = super.readSetBegin();
        ThriftBinaryProtocol.checkContainerElemType(set.elemType);
        return set;
    }

    public static class Factory
    implements TProtocolFactory {
        public TProtocol getProtocol(TTransport trans) {
            return new ThriftBinaryProtocol(trans);
        }
    }
}

