/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.TypeRef;
import com.twitter.elephantbird.util.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class ThriftUtils {
    private static final String CLASS_CONF_PREFIX = "elephantbird.thrift.class.for.";

    public static void setClassConf(Configuration jobConf, Class<?> genericClass, Class<? extends TBase<?, ?>> thriftClass) {
        String configKey = CLASS_CONF_PREFIX + genericClass.getName();
        HadoopUtils.setClassConf(jobConf, configKey, thriftClass);
    }

    private static void verifyAncestry(Class<?> tClass) {
        if (!TBase.class.isAssignableFrom(tClass)) {
            Utils.ensureClassLoaderConsistency(TBase.class, tClass.getClassLoader());
            throw new ClassCastException(tClass.getName() + " is not a Thrift class");
        }
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(Configuration jobConf, Class<?> genericClass) {
        String className = jobConf.get(CLASS_CONF_PREFIX + genericClass.getName());
        if (className == null) {
            throw new RuntimeException(CLASS_CONF_PREFIX + genericClass.getName() + " is not set");
        }
        Class tClass = null;
        try {
            tClass = jobConf.getClassByName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ThriftUtils.verifyAncestry(tClass);
        return new TypeRef<M>(tClass){};
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(Class<?> tClass) {
        ThriftUtils.verifyAncestry(tClass);
        return new TypeRef<M>(tClass){};
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(String thriftClassName, ClassLoader classLoader) {
        try {
            Class<?> tClass = classLoader == null ? Class.forName(thriftClassName) : Class.forName(thriftClassName, true, classLoader);
            ThriftUtils.verifyAncestry(tClass);
            return new TypeRef<M>(tClass){};
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(String thriftClassName) {
        return ThriftUtils.getTypeRef(thriftClassName, null);
    }

    public static <M> M getFieldValue(Object containingObject, String fieldName, Class<M> fieldClass) {
        return ThriftUtils.getFieldValue(containingObject.getClass(), containingObject, fieldName, fieldClass);
    }

    public static <M> M getFieldValue(Class<?> containingClass, String fieldName, Class<M> fieldClass) {
        return ThriftUtils.getFieldValue(containingClass, null, fieldName, fieldClass);
    }

    private static <M> M getFieldValue(Class<?> containingClass, Object obj, String fieldName, Class<M> fieldClass) {
        try {
            Field field = containingClass.getDeclaredField(fieldName);
            return fieldClass.cast(field.get(obj));
        }
        catch (Exception e) {
            throw new RuntimeException("while trying to find " + fieldName + " in " + containingClass.getName(), e);
        }
    }

    public static Type getFieldType(Class<?> containingClass, String fieldName) {
        String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        for (String prefix : new String[]{"get", "is"}) {
            try {
                Method method = containingClass.getDeclaredMethod(prefix + suffix, new Class[0]);
                return method.getGenericReturnType();
            }
            catch (NoSuchMethodException e) {
            }
        }
        throw new RuntimeException("could not find type for " + fieldName + " in " + containingClass);
    }

    public static Class<?> getFieldValueType(TStructDescriptor.Field field) {
        switch (field.getType()) {
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Byte.class;
            }
            case 4: {
                return Double.class;
            }
            case 16: {
                return field.getEnumClass();
            }
            case 6: {
                return Short.class;
            }
            case 8: {
                return Integer.class;
            }
            case 10: {
                return Long.class;
            }
            case 15: {
                return List.class;
            }
            case 13: {
                return Map.class;
            }
            case 14: {
                return Set.class;
            }
            case 0: {
                return null;
            }
            case 11: {
                return String.class;
            }
            case 12: {
                return field.gettStructDescriptor().getThriftClass();
            }
            case 1: {
                return null;
            }
        }
        return null;
    }

    private static void writeSingleFieldNoTag(TProtocol proto, TStructDescriptor.Field field, Object value) throws TException {
        switch (field.getType()) {
            case 2: {
                proto.writeBool(((Boolean)value).booleanValue());
                break;
            }
            case 3: {
                proto.writeByte(((Byte)value).byteValue());
                break;
            }
            case 6: {
                proto.writeI16(((Short)value).shortValue());
                break;
            }
            case 8: {
                proto.writeI32(((Integer)value).intValue());
                break;
            }
            case 16: {
                proto.writeI32(((TEnum)value).getValue());
                break;
            }
            case 10: {
                proto.writeI64(((Long)value).longValue());
                break;
            }
            case 4: {
                proto.writeDouble(((Double)value).doubleValue());
                break;
            }
            case 11: {
                if (value instanceof String) {
                    proto.writeString((String)value);
                    break;
                }
                proto.writeBinary((ByteBuffer)value);
                break;
            }
            case 12: {
                ((TBase)value).write(proto);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type : " + field.getType());
            }
        }
    }

    public static void writeFieldNoTag(TProtocol proto, TStructDescriptor.Field field, Object value) throws TException {
        if (value == null) {
            return;
        }
        TStructDescriptor.Field innerField = null;
        switch (field.getType()) {
            case 15: {
                innerField = field.getListElemField();
                break;
            }
            case 14: {
                innerField = field.getSetElemField();
                break;
            }
            case 13: {
                innerField = field.getMapKeyField();
                break;
            }
            default: {
                ThriftUtils.writeSingleFieldNoTag(proto, field, value);
                return;
            }
        }
        if (field.getType() == 13) {
            TStructDescriptor.Field valueField = field.getMapValueField();
            Map map = (Map)value;
            proto.writeByte(innerField.getType());
            proto.writeByte(valueField.getType());
            proto.writeI32(map.size());
            for (Map.Entry entry : map.entrySet()) {
                ThriftUtils.writeSingleFieldNoTag(proto, innerField, entry.getKey());
                ThriftUtils.writeSingleFieldNoTag(proto, valueField, entry.getValue());
            }
        } else {
            Collection coll = (Collection)value;
            proto.writeByte(innerField.getType());
            proto.writeI32(coll.size());
            for (Object v : coll) {
                ThriftUtils.writeSingleFieldNoTag(proto, innerField, v);
            }
        }
    }

    private static Object readSingleFieldNoTag(TProtocol proto, TStructDescriptor.Field field) throws TException {
        switch (field.getType()) {
            case 2: {
                return proto.readBool();
            }
            case 3: {
                return proto.readByte();
            }
            case 6: {
                return proto.readI16();
            }
            case 8: {
                return proto.readI32();
            }
            case 16: {
                return field.getEnumValueOf(proto.readI32());
            }
            case 10: {
                return proto.readI64();
            }
            case 4: {
                return proto.readDouble();
            }
            case 11: {
                return field.isBuffer() ? proto.readBinary() : proto.readString();
            }
            case 12: {
                TBase<?, ?> tObj = field.gettStructDescriptor().newThriftObject();
                tObj.read(proto);
                return tObj;
            }
        }
        throw new IllegalArgumentException("Unexpected type : " + field.getType());
    }

    public static Object readFieldNoTag(TProtocol proto, TStructDescriptor.Field field) throws TException {
        AbstractCollection coll = null;
        TStructDescriptor.Field innerField = null;
        switch (field.getType()) {
            case 15: {
                innerField = field.getListElemField();
                coll = Lists.newArrayList();
                break;
            }
            case 14: {
                innerField = field.getSetElemField();
                coll = Sets.newHashSet();
                break;
            }
            case 13: {
                innerField = field.getMapKeyField();
                break;
            }
            default: {
                return ThriftUtils.readSingleFieldNoTag(proto, field);
            }
        }
        if (field.getType() == 13) {
            proto.readByte();
            proto.readByte();
            int nEntries = proto.readI32();
            HashMap map = Maps.newHashMap();
            TStructDescriptor.Field valueField = field.getMapValueField();
            for (int i = 0; i < nEntries; ++i) {
                map.put(ThriftUtils.readFieldNoTag(proto, innerField), ThriftUtils.readFieldNoTag(proto, valueField));
            }
            return map;
        }
        proto.readByte();
        int nEntries = proto.readI32();
        for (int i = 0; i < nEntries; ++i) {
            coll.add(ThriftUtils.readFieldNoTag(proto, innerField));
        }
        return coll;
    }
}

