/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.piggybank;

import com.twitter.elephantbird.mapreduce.io.ThriftConverter;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.thrift.TBase;

public class ThriftBytesToTuple<M extends TBase<?, ?>>
extends EvalFunc<Tuple> {
    private final TypeRef<M> typeRef;
    private final ThriftConverter<M> thriftConverter;
    private final ThriftToPig<M> thriftToPig;

    public ThriftBytesToTuple(String thriftClassName) {
        this.typeRef = PigUtil.getThriftTypeRef(thriftClassName);
        this.thriftConverter = ThriftConverter.newInstance(this.typeRef);
        this.thriftToPig = ThriftToPig.newInstance(this.typeRef);
    }

    public Tuple exec(Tuple input) throws IOException {
        if (input == null || input.size() < 1) {
            return null;
        }
        try {
            DataByteArray bytes = (DataByteArray)input.get(0);
            TBase value = this.thriftConverter.fromBytes(bytes.get());
            return value == null ? null : this.thriftToPig.getPigTuple(value);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Schema outputSchema(Schema input) {
        return PigUtil.outputSchemaForThrift(this.typeRef);
    }
}

