/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import com.twitter.elephantbird.pig.util.PigToThrift;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.thrift.TBase;

public class ThriftWritableConverter<M extends TBase<?, ?>>
extends AbstractWritableConverter<ThriftWritable<M>> {
    protected final TypeRef<M> typeRef;
    protected final ThriftToPig<M> thriftToPig;
    protected final Schema expectedSchema;
    protected final PigToThrift<M> pigToThrift;

    public ThriftWritableConverter(String thriftClassName) {
        super(new ThriftWritable());
        Preconditions.checkNotNull((Object)thriftClassName);
        this.typeRef = PigUtil.getThriftTypeRef(thriftClassName);
        this.thriftToPig = ThriftToPig.newInstance(this.typeRef);
        this.expectedSchema = this.thriftToPig.toSchema();
        this.pigToThrift = PigToThrift.newInstance(this.typeRef);
        ((ThriftWritable)this.writable).setConverter(this.typeRef.getRawClass());
    }

    @Override
    public void initialize(Class<? extends ThriftWritable<M>> writableClass) throws IOException {
        if (writableClass == null) {
            return;
        }
        super.initialize(writableClass);
        ((ThriftWritable)this.writable).setConverter(this.typeRef.getRawClass());
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        return new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(null, this.expectedSchema));
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema schema) throws IOException {
        Preconditions.checkNotNull((Object)schema, (Object)"Schema is null");
        Preconditions.checkArgument((110 == schema.getType() ? 1 : 0) != 0, (String)"Expected schema type '%s' but found type '%s'", (Object[])new Object[]{DataType.findTypeName((byte)110), DataType.findTypeName((byte)schema.getType())});
        ResourceSchema childSchema = schema.getSchema();
        Preconditions.checkNotNull((Object)childSchema, (Object)"Child schema is null");
        Schema actualSchema = Schema.getPigSchema((ResourceSchema)childSchema);
        Preconditions.checkArgument((boolean)Schema.equals((Schema)this.expectedSchema, (Schema)actualSchema, (boolean)false, (boolean)true), (String)"Expected store schema '%s' but found schema '%s'", (Object[])new Object[]{this.expectedSchema, actualSchema});
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return this.bytesToTuple(dataByteArray.get(), null);
    }

    @Override
    protected Tuple toTuple(ThriftWritable<M> writable, ResourceSchema.ResourceFieldSchema schema) throws IOException {
        return this.thriftToPig.getPigTuple((TBase)writable.get());
    }

    @Override
    protected ThriftWritable<M> toWritable(Tuple value) throws IOException {
        ((ThriftWritable)this.writable).set(this.pigToThrift.getThriftObject(value));
        return (ThriftWritable)this.writable;
    }
}

