/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.collection.RecordSchema;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Method$Get$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Request$;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$Http11$;
import com.twitter.finagle.http.netty.Bijections$;
import com.twitter.io.Reader;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.handler.codec.embedder.DecoderEmbedder;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringEncoder;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;

public final class Request$ {
    public static final Request$ MODULE$;
    private final RecordSchema Schema;

    static {
        new Request$();
    }

    public Request apply(Tuple2<String, String> ... params) {
        return this.apply((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])params));
    }

    public RecordSchema Schema() {
        return this.Schema;
    }

    public Request decodeString(String s) {
        return this.decodeBytes(s.getBytes(StandardCharsets.UTF_8));
    }

    public Request decodeBytes(byte[] b) {
        DecoderEmbedder decoder = new DecoderEmbedder(new ChannelUpstreamHandler[]{new HttpRequestDecoder(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)});
        decoder.offer((Object)ChannelBuffers.wrappedBuffer((byte[])b));
        HttpRequest req = (HttpRequest)decoder.poll();
        Predef$.MODULE$.assert(req != null);
        return new Request(req){
            private final HttpRequest httpRequest;
            private InetSocketAddress remoteSocketAddress;
            private volatile boolean bitmap$0;

            private InetSocketAddress remoteSocketAddress$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.remoteSocketAddress = new InetSocketAddress(0);
                        this.bitmap$0 = true;
                    }
                    return this.remoteSocketAddress;
                }
            }

            public HttpRequest httpRequest() {
                return this.httpRequest;
            }

            public InetSocketAddress remoteSocketAddress() {
                return this.bitmap$0 ? this.remoteSocketAddress : this.remoteSocketAddress$lzycompute();
            }
            {
                this.httpRequest = req$1;
            }
        };
    }

    public Request apply(Seq<Tuple2<String, String>> params) {
        return this.apply("/", params);
    }

    public Request apply(String uri, Seq<Tuple2<String, String>> params) {
        QueryStringEncoder encoder = new QueryStringEncoder(uri);
        params.foreach((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final QueryStringEncoder encoder$1;

            public final void apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    this.encoder$1.addParam(key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.encoder$1 = encoder$1;
            }
        });
        return this.apply(Method$Get$.MODULE$, encoder.toString());
    }

    public Request apply(String uri) {
        return this.apply(Method$Get$.MODULE$, uri);
    }

    public Request apply(Method method, String uri) {
        return this.apply(Version$Http11$.MODULE$, method, uri);
    }

    public Request apply(Version version, Method method, String uri) {
        DefaultHttpRequest reqIn = new DefaultHttpRequest((HttpVersion)Bijections$.MODULE$.from(version, Bijections$.MODULE$.versionToNetty()), (HttpMethod)Bijections$.MODULE$.from(method, Bijections$.MODULE$.methodToNetty()), uri);
        return new Request(reqIn){
            private final HttpRequest httpRequest;
            private InetSocketAddress remoteSocketAddress;
            private volatile boolean bitmap$0;

            private InetSocketAddress remoteSocketAddress$lzycompute() {
                anon.2 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.remoteSocketAddress = new InetSocketAddress(0);
                        this.bitmap$0 = true;
                    }
                    return this.remoteSocketAddress;
                }
            }

            public HttpRequest httpRequest() {
                return this.httpRequest;
            }

            public InetSocketAddress remoteSocketAddress() {
                return this.bitmap$0 ? this.remoteSocketAddress : this.remoteSocketAddress$lzycompute();
            }
            {
                this.httpRequest = reqIn$2;
            }
        };
    }

    public Request apply(Version version, Method method, String uri, Reader reader) {
        DefaultHttpRequest httpReq = new DefaultHttpRequest((HttpVersion)Bijections$.MODULE$.from(version, Bijections$.MODULE$.versionToNetty()), (HttpMethod)Bijections$.MODULE$.from(method, Bijections$.MODULE$.methodToNetty()), uri);
        httpReq.setChunked(true);
        return this.apply((HttpRequest)httpReq, reader, new InetSocketAddress(0));
    }

    public Request apply(Version version, Method method, String uri, Reader reader, InetSocketAddress remoteAddr) {
        DefaultHttpRequest httpReq = new DefaultHttpRequest((HttpVersion)Bijections$.MODULE$.from(version, Bijections$.MODULE$.versionToNetty()), (HttpMethod)Bijections$.MODULE$.from(method, Bijections$.MODULE$.methodToNetty()), uri);
        httpReq.setChunked(true);
        return this.apply((HttpRequest)httpReq, reader, remoteAddr);
    }

    public Request apply(HttpRequest reqIn, Reader readerIn, InetSocketAddress remoteAddr) {
        return new Request(reqIn, readerIn, remoteAddr){
            private final Reader reader;
            private final HttpRequest httpRequest;
            private InetSocketAddress remoteSocketAddress;
            private final InetSocketAddress remoteAddr$1;
            private volatile boolean bitmap$0;

            private InetSocketAddress remoteSocketAddress$lzycompute() {
                anon.3 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.remoteSocketAddress = this.remoteAddr$1;
                        this.bitmap$0 = true;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.remoteAddr$1 = null;
                    return this.remoteSocketAddress;
                }
            }

            public Reader reader() {
                return this.reader;
            }

            public HttpRequest httpRequest() {
                return this.httpRequest;
            }

            public InetSocketAddress remoteSocketAddress() {
                return this.bitmap$0 ? this.remoteSocketAddress : this.remoteSocketAddress$lzycompute();
            }
            {
                this.remoteAddr$1 = remoteAddr$1;
                this.reader = readerIn$1;
                this.httpRequest = reqIn$1;
            }
        };
    }

    public Request apply(HttpRequest httpRequestArg, Channel channel) {
        return new Request(httpRequestArg, channel){
            private final HttpRequest httpRequest;
            private InetSocketAddress remoteSocketAddress;
            private final Channel channel$1;
            private volatile boolean bitmap$0;

            private InetSocketAddress remoteSocketAddress$lzycompute() {
                anon.4 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.remoteSocketAddress = (InetSocketAddress)this.channel$1.getRemoteAddress();
                        this.bitmap$0 = true;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.channel$1 = null;
                    return this.remoteSocketAddress;
                }
            }

            public HttpRequest httpRequest() {
                return this.httpRequest;
            }

            public InetSocketAddress remoteSocketAddress() {
                return this.bitmap$0 ? this.remoteSocketAddress : this.remoteSocketAddress$lzycompute();
            }
            {
                this.channel$1 = channel$1;
                this.httpRequest = httpRequestArg$1;
            }
        };
    }

    public String queryString(String uri, Seq<Tuple2<String, String>> params) {
        QueryStringEncoder encoder = new QueryStringEncoder(uri);
        params.foreach((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final QueryStringEncoder encoder$2;

            public final void apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    this.encoder$2.addParam(key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.encoder$2 = encoder$2;
            }
        });
        return encoder.toString();
    }

    public String queryString(Seq<Tuple2<String, String>> params) {
        return this.queryString("", params);
    }

    public String queryString(String uri, Map<String, String> params) {
        return this.queryString(uri, (Seq<Tuple2<String, String>>)params.toSeq());
    }

    public String queryString(Map<String, String> params) {
        return this.queryString("", (Seq<Tuple2<String, String>>)params.toSeq());
    }

    private Request$() {
        MODULE$ = this;
        this.Schema = new RecordSchema();
    }
}

