/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import scala.runtime.BoxedUnit;

@ChannelHandler.Sharable
public final class DirectToHeapInboundHandler$
extends ChannelInboundHandlerAdapter {
    public static final DirectToHeapInboundHandler$ MODULE$;

    static {
        new DirectToHeapInboundHandler$();
    }

    private final ByteBuf copyOnHeap(ByteBuf bb, ByteBufAllocator alloc) {
        try {
            return alloc.heapBuffer(bb.readableBytes(), bb.capacity()).writeBytes(bb);
        }
        finally {
            bb.release();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBufHolder byteBufHolder;
        ByteBuf byteBuf;
        Object object = msg;
        if (object instanceof ByteBuf && (byteBuf = (ByteBuf)object).isDirect()) {
            ctx.fireChannelRead((Object)this.copyOnHeap(byteBuf, ctx.alloc()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof ByteBufHolder && (byteBufHolder = (ByteBufHolder)object).content().isDirect()) {
            ByteBuf onHeapContent = this.copyOnHeap(byteBufHolder.content(), ctx.alloc());
            ctx.fireChannelRead((Object)byteBufHolder.replace(onHeapContent));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ctx.fireChannelRead(msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private DirectToHeapInboundHandler$() {
        MODULE$ = this;
    }
}

