/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.zipkin.thrift;

import com.twitter.finagle.zipkin.thrift.Endpoint;
import com.twitter.util.NonFatal$;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Endpoint$
implements Serializable {
    public static final Endpoint$ MODULE$;
    private final Logger log;
    private final int Loopback;
    private final Endpoint Unknown;
    private final Endpoint Local;
    private int getLocalHost;
    private volatile boolean bitmap$0;

    static {
        new Endpoint$();
    }

    private int getLocalHost$lzycompute() {
        Endpoint$ endpoint$ = this;
        synchronized (endpoint$) {
            if (!this.bitmap$0) {
                this.getLocalHost = this.Local().ipv4();
                this.bitmap$0 = true;
            }
            return this.getLocalHost;
        }
    }

    public int Loopback() {
        return this.Loopback;
    }

    public Endpoint Unknown() {
        return this.Unknown;
    }

    public Endpoint Local() {
        return this.Local;
    }

    public int toIpv4(InetAddress inetAddress) {
        return ByteBuffer.wrap(inetAddress.getAddress()).getInt();
    }

    public int getLocalHost() {
        return this.bitmap$0 ? this.getLocalHost : this.getLocalHost$lzycompute();
    }

    public Endpoint fromSocketAddress(SocketAddress socketAddress) {
        Endpoint endpoint;
        SocketAddress socketAddress2 = socketAddress;
        if (socketAddress2 instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress2;
            endpoint = new Endpoint(this.toIpv4(inetSocketAddress.getAddress()), (short)inetSocketAddress.getPort());
        } else {
            endpoint = this.Unknown();
        }
        return endpoint;
    }

    public Endpoint apply(int ipv4, short port) {
        return new Endpoint(ipv4, port);
    }

    public Option<Tuple2<Object, Object>> unapply(Endpoint x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)x$0.ipv4()), (Object)BoxesRunTime.boxToShort((short)x$0.port())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Endpoint liftedTree1$1() {
        Endpoint endpoint;
        try {
            int ipv4 = this.toIpv4(InetAddress.getLoopbackAddress());
            endpoint = new Endpoint(ipv4, 0);
        }
        catch (Throwable throwable) {
            Endpoint endpoint2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            endpoint = endpoint2 = this.Unknown();
        }
        return endpoint;
    }

    private Endpoint$() {
        MODULE$ = this;
        this.log = Logger.getLogger(this.getClass().toString());
        this.Loopback = this.toIpv4(InetAddress.getByAddress((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{127, 0, 0, 1}), ClassTag$.MODULE$.Byte())));
        this.Unknown = new Endpoint(0, 0);
        this.Local = this.liftedTree1$1();
    }
}

