/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.httpclient;

import com.google.common.base.Preconditions;
import com.twitter.hbc.httpclient.auth.Authentication;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class RestartableHttpClient
implements HttpClient {
    private final AtomicReference<HttpClient> underlying;
    private final Authentication auth;
    private final HttpParams params;
    private final boolean enableGZip;
    private final SchemeRegistry schemeRegistry;

    public RestartableHttpClient(Authentication auth, boolean enableGZip, HttpParams params, SchemeRegistry schemeRegistry) {
        this.auth = (Authentication)Preconditions.checkNotNull((Object)auth);
        this.enableGZip = enableGZip;
        this.params = (HttpParams)Preconditions.checkNotNull((Object)params);
        this.schemeRegistry = (SchemeRegistry)Preconditions.checkNotNull((Object)schemeRegistry);
        this.underlying = new AtomicReference();
    }

    public void setup() {
        DefaultHttpClient defaultClient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager(this.schemeRegistry), this.params);
        this.auth.setupConnection((AbstractHttpClient)defaultClient);
        if (this.enableGZip) {
            this.underlying.set((HttpClient)new DecompressingHttpClient((HttpClient)defaultClient));
        } else {
            this.underlying.set((HttpClient)defaultClient);
        }
    }

    public void restart() {
        HttpClient old = this.underlying.get();
        if (old != null) {
            old.getConnectionManager().shutdown();
        }
        this.setup();
    }

    public HttpParams getParams() {
        return this.underlying.get().getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.underlying.get().getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.underlying.get().execute(request);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.underlying.get().execute(request, context);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.underlying.get().execute(target, request);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.underlying.get().execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.underlying.get().execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.underlying.get().execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.underlying.get().execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.underlying.get().execute(target, request, responseHandler, context);
    }
}

