/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hpack;

import com.twitter.hpack.HeaderField;
import com.twitter.hpack.HeaderListener;
import com.twitter.hpack.HeaderTable;
import com.twitter.hpack.HpackUtil;
import com.twitter.hpack.Huffman;
import com.twitter.hpack.StaticTable;
import java.io.IOException;
import java.io.InputStream;

public final class Decoder {
    private static final IOException DECOMPRESSION_EXCEPTION = new IOException("decompression failure");
    private static final IOException ILLEGAL_INDEX_VALUE = new IOException("illegal index value");
    private static final IOException ILLEGAL_ENCODING_CONTEXT_UPDATE = new IOException("illegal encoding context update");
    private static final IOException INVALID_MAX_HEADER_TABLE_SIZE = new IOException("invalid max header table size");
    private static final IOException MAX_HEADER_TABLE_SIZE_CHANGE_REQUIRED = new IOException("max header table size change required");
    private static final byte[] EMPTY = new byte[0];
    private final HeaderTable headerTable;
    private int maxHeaderSize;
    private int maxHeaderTableSize;
    private int encoderMaxHeaderTableSize;
    private boolean maxHeaderTableSizeChangeRequired;
    private long headerSize;
    private State state;
    private HpackUtil.IndexType indexType;
    private int index;
    private boolean huffmanEncoded;
    private int skipLength;
    private int nameLength;
    private int valueLength;
    private byte[] name;

    public Decoder(int maxHeaderSize, int maxHeaderTableSize) {
        this.headerTable = new HeaderTable(maxHeaderTableSize);
        this.maxHeaderSize = maxHeaderSize;
        this.maxHeaderTableSize = maxHeaderTableSize;
        this.encoderMaxHeaderTableSize = maxHeaderTableSize;
        this.maxHeaderTableSizeChangeRequired = false;
        this.reset();
    }

    private void reset() {
        this.headerSize = 0L;
        this.state = State.READ_HEADER_REPRESENTATION;
        this.indexType = HpackUtil.IndexType.NONE;
    }

    public void decode(InputStream in, HeaderListener headerListener) throws IOException {
        block14: while (in.available() > 0) {
            switch (this.state) {
                case READ_HEADER_REPRESENTATION: {
                    byte b = (byte)in.read();
                    if (this.maxHeaderTableSizeChangeRequired && (b & 0xF0) != 32) {
                        throw MAX_HEADER_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (b < 0) {
                        this.index = b & 0x7F;
                        if (this.index == 0) {
                            throw ILLEGAL_INDEX_VALUE;
                        }
                        if (this.index == 127) {
                            this.state = State.READ_INDEXED_HEADER;
                            break;
                        }
                        this.indexHeader(this.index, headerListener);
                        break;
                    }
                    if ((b & 0x40) == 64) {
                        this.indexType = HpackUtil.IndexType.INCREMENTAL;
                        this.index = b & 0x3F;
                        if (this.index == 0) {
                            this.state = State.READ_LITERAL_HEADER_NAME_LENGTH_PREFIX;
                            break;
                        }
                        if (this.index == 63) {
                            this.state = State.READ_INDEXED_HEADER_NAME;
                            break;
                        }
                        this.readName(this.index);
                        this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                        break;
                    }
                    if ((b & 0x20) == 32) {
                        this.index = b & 0x1F;
                        if (this.index == 31) {
                            this.state = State.READ_MAX_HEADER_TABLE_SIZE;
                            break;
                        }
                        this.setHeaderTableSize(this.index);
                        this.state = State.READ_HEADER_REPRESENTATION;
                        break;
                    }
                    this.indexType = (b & 0x10) == 16 ? HpackUtil.IndexType.NEVER : HpackUtil.IndexType.NONE;
                    this.index = b & 0xF;
                    if (this.index == 0) {
                        this.state = State.READ_LITERAL_HEADER_NAME_LENGTH_PREFIX;
                        break;
                    }
                    if (this.index == 15) {
                        this.state = State.READ_INDEXED_HEADER_NAME;
                        break;
                    }
                    this.readName(this.index);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    break;
                }
                case READ_MAX_HEADER_TABLE_SIZE: {
                    int headerTableSize = Decoder.decodeULE128(in);
                    if (headerTableSize == -1) {
                        return;
                    }
                    if (headerTableSize > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.setHeaderTableSize(this.index + headerTableSize);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    break;
                }
                case READ_INDEXED_HEADER: {
                    int headerIndex = Decoder.decodeULE128(in);
                    if (headerIndex == -1) {
                        return;
                    }
                    if (headerIndex > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.indexHeader(this.index + headerIndex, headerListener);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    break;
                }
                case READ_INDEXED_HEADER_NAME: {
                    int nameIndex = Decoder.decodeULE128(in);
                    if (nameIndex == -1) {
                        return;
                    }
                    if (nameIndex > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.readName(this.index + nameIndex);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    break;
                }
                case READ_LITERAL_HEADER_NAME_LENGTH_PREFIX: {
                    byte b = (byte)in.read();
                    this.huffmanEncoded = (b & 0x80) == 128;
                    this.index = b & 0x7F;
                    if (this.index == 127) {
                        this.state = State.READ_LITERAL_HEADER_NAME_LENGTH;
                        break;
                    }
                    this.nameLength = this.index;
                    if (this.nameLength == 0) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    if (this.exceedsMaxHeaderSize(this.nameLength)) {
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            break;
                        }
                        if (this.nameLength + 32 > this.headerTable.capacity()) {
                            this.headerTable.clear();
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            break;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_NAME;
                    break;
                }
                case READ_LITERAL_HEADER_NAME_LENGTH: {
                    this.nameLength = Decoder.decodeULE128(in);
                    if (this.nameLength == -1) {
                        return;
                    }
                    if (this.nameLength > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.nameLength += this.index;
                    if (this.exceedsMaxHeaderSize(this.nameLength)) {
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            break;
                        }
                        if (this.nameLength + 32 > this.headerTable.capacity()) {
                            this.headerTable.clear();
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            break;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_NAME;
                    break;
                }
                case READ_LITERAL_HEADER_NAME: {
                    if (in.available() < this.nameLength) {
                        return;
                    }
                    this.name = this.readStringLiteral(in, this.nameLength);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    break;
                }
                case SKIP_LITERAL_HEADER_NAME: {
                    this.skipLength = (int)((long)this.skipLength - in.skip(this.skipLength));
                    if (this.skipLength != 0) continue block14;
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    break;
                }
                case READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX: {
                    byte b = (byte)in.read();
                    this.huffmanEncoded = (b & 0x80) == 128;
                    this.index = b & 0x7F;
                    if (this.index == 127) {
                        this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH;
                        break;
                    }
                    this.valueLength = this.index;
                    long newHeaderSize = (long)this.nameLength + (long)this.valueLength;
                    if (this.exceedsMaxHeaderSize(newHeaderSize)) {
                        this.headerSize = this.maxHeaderSize + 1;
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            break;
                        }
                        if (newHeaderSize + 32L > (long)this.headerTable.capacity()) {
                            this.headerTable.clear();
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            break;
                        }
                    }
                    if (this.valueLength == 0) {
                        this.insertHeader(headerListener, this.name, EMPTY, this.indexType);
                        this.state = State.READ_HEADER_REPRESENTATION;
                        break;
                    }
                    this.state = State.READ_LITERAL_HEADER_VALUE;
                    break;
                }
                case READ_LITERAL_HEADER_VALUE_LENGTH: {
                    this.valueLength = Decoder.decodeULE128(in);
                    if (this.valueLength == -1) {
                        return;
                    }
                    if (this.valueLength > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.valueLength += this.index;
                    long newHeaderSize = (long)this.nameLength + (long)this.valueLength;
                    if (newHeaderSize + this.headerSize > (long)this.maxHeaderSize) {
                        this.headerSize = this.maxHeaderSize + 1;
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            break;
                        }
                        if (newHeaderSize + 32L > (long)this.headerTable.capacity()) {
                            this.headerTable.clear();
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            break;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_VALUE;
                    break;
                }
                case READ_LITERAL_HEADER_VALUE: {
                    if (in.available() < this.valueLength) {
                        return;
                    }
                    byte[] value = this.readStringLiteral(in, this.valueLength);
                    this.insertHeader(headerListener, this.name, value, this.indexType);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    break;
                }
                case SKIP_LITERAL_HEADER_VALUE: {
                    this.valueLength = (int)((long)this.valueLength - in.skip(this.valueLength));
                    if (this.valueLength != 0) continue block14;
                    this.state = State.READ_HEADER_REPRESENTATION;
                    break;
                }
                default: {
                    throw new IllegalStateException("should not reach here");
                }
            }
        }
    }

    public boolean endHeaderBlock() {
        boolean truncated = this.headerSize > (long)this.maxHeaderSize;
        this.reset();
        return truncated;
    }

    public void setMaxHeaderTableSize(int maxHeaderTableSize) {
        this.maxHeaderTableSize = maxHeaderTableSize;
        if (maxHeaderTableSize < this.encoderMaxHeaderTableSize) {
            this.maxHeaderTableSizeChangeRequired = true;
            this.headerTable.setCapacity(maxHeaderTableSize);
        }
    }

    public int getMaxHeaderTableSize() {
        return this.headerTable.capacity();
    }

    int length() {
        return this.headerTable.length();
    }

    int size() {
        return this.headerTable.size();
    }

    HeaderField getHeaderField(int index) {
        return this.headerTable.getEntry(index + 1);
    }

    private void setHeaderTableSize(int headerTableSize) throws IOException {
        if (headerTableSize > this.maxHeaderTableSize) {
            throw INVALID_MAX_HEADER_TABLE_SIZE;
        }
        this.encoderMaxHeaderTableSize = headerTableSize;
        this.maxHeaderTableSizeChangeRequired = false;
        this.headerTable.setCapacity(headerTableSize);
    }

    private void readName(int index) throws IOException {
        if (index <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(index);
            this.name = headerField.name;
        } else if (index - StaticTable.length <= this.headerTable.length()) {
            HeaderField headerField = this.headerTable.getEntry(index - StaticTable.length);
            this.name = headerField.name;
        } else {
            throw ILLEGAL_INDEX_VALUE;
        }
    }

    private void indexHeader(int index, HeaderListener headerListener) throws IOException {
        if (index <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(index);
            this.addHeader(headerListener, headerField.name, headerField.value, false);
        } else if (index - StaticTable.length <= this.headerTable.length()) {
            HeaderField headerField = this.headerTable.getEntry(index - StaticTable.length);
            this.addHeader(headerListener, headerField.name, headerField.value, false);
        } else {
            throw ILLEGAL_INDEX_VALUE;
        }
    }

    private void insertHeader(HeaderListener headerListener, byte[] name, byte[] value, HpackUtil.IndexType indexType) {
        this.addHeader(headerListener, name, value, indexType == HpackUtil.IndexType.NEVER);
        switch (indexType) {
            case NONE: 
            case NEVER: {
                break;
            }
            case INCREMENTAL: {
                this.headerTable.add(new HeaderField(name, value));
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here");
            }
        }
    }

    private void addHeader(HeaderListener headerListener, byte[] name, byte[] value, boolean sensitive) {
        if (name.length == 0) {
            throw new AssertionError((Object)"name is empty");
        }
        long newSize = this.headerSize + (long)name.length + (long)value.length;
        if (newSize <= (long)this.maxHeaderSize) {
            headerListener.addHeader(name, value, sensitive);
            this.headerSize = (int)newSize;
        } else {
            this.headerSize = this.maxHeaderSize + 1;
        }
    }

    private boolean exceedsMaxHeaderSize(long size) {
        if (size + this.headerSize <= (long)this.maxHeaderSize) {
            return false;
        }
        this.headerSize = this.maxHeaderSize + 1;
        return true;
    }

    private byte[] readStringLiteral(InputStream in, int length) throws IOException {
        byte[] buf = new byte[length];
        if (in.read(buf) != length) {
            throw DECOMPRESSION_EXCEPTION;
        }
        if (this.huffmanEncoded) {
            return Huffman.DECODER.decode(buf);
        }
        return buf;
    }

    private static int decodeULE128(InputStream in) throws IOException {
        in.mark(5);
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            if (in.available() == 0) {
                in.reset();
                return -1;
            }
            byte b = (byte)in.read();
            if (shift == 28 && (b & 0xF8) != 0) break;
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        in.reset();
        throw DECOMPRESSION_EXCEPTION;
    }

    private static enum State {
        READ_HEADER_REPRESENTATION,
        READ_MAX_HEADER_TABLE_SIZE,
        READ_INDEXED_HEADER,
        READ_INDEXED_HEADER_NAME,
        READ_LITERAL_HEADER_NAME_LENGTH_PREFIX,
        READ_LITERAL_HEADER_NAME_LENGTH,
        READ_LITERAL_HEADER_NAME,
        SKIP_LITERAL_HEADER_NAME,
        READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX,
        READ_LITERAL_HEADER_VALUE_LENGTH,
        READ_LITERAL_HEADER_VALUE,
        SKIP_LITERAL_HEADER_VALUE;

    }
}

