/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.statistics;

import parquet.bytes.BytesUtils;
import parquet.column.statistics.Statistics;

public class BooleanStatistics
extends Statistics {
    private boolean max;
    private boolean min;

    @Override
    public void updateStats(boolean value) {
        if (this.isEmpty()) {
            this.initializeStats(value, value);
        } else {
            this.updateStats(value, value);
        }
    }

    @Override
    public void mergeStatisticsMinMax(Statistics stats) {
        BooleanStatistics boolStats = (BooleanStatistics)stats;
        if (this.isEmpty()) {
            this.initializeStats(boolStats.getMin(), boolStats.getMax());
        } else {
            this.updateStats(boolStats.getMin(), boolStats.getMax());
        }
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = BytesUtils.bytesToBool((byte[])maxBytes);
        this.min = BytesUtils.bytesToBool((byte[])minBytes);
        this.markAsNotEmpty();
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.booleanToBytes((boolean)this.max);
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.booleanToBytes((boolean)this.min);
    }

    @Override
    public String toString() {
        if (!this.isEmpty()) {
            return String.format("min: %b, max: %b, num_nulls: %d", this.min, this.max, this.getNumNulls());
        }
        return "no stats for this column";
    }

    public void updateStats(boolean min_value, boolean max_value) {
        if (this.min && !min_value) {
            this.min = min_value;
        }
        if (!this.max && max_value) {
            this.max = max_value;
        }
    }

    public void initializeStats(boolean min_value, boolean max_value) {
        this.min = min_value;
        this.max = max_value;
        this.markAsNotEmpty();
    }

    public boolean getMax() {
        return this.max;
    }

    public boolean getMin() {
        return this.min;
    }

    public void setMinMax(boolean min, boolean max) {
        this.max = max;
        this.min = min;
        this.markAsNotEmpty();
    }
}

