/*
 * Decompiled with CFR 0.152.
 */
package com.wuwenze.poi.util;

import java.util.regex.Pattern;

public class ValidatorUtil {
    private static final Pattern PATTERN_NUMERIC = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
    private static final Pattern PATTERN_EMAIL = Pattern.compile("^[\\w-]+(\\.[\\w-]+)*@[\\w-]+(\\.[\\w-]+)+$");
    private static final Pattern PATTERN_MOBILE_PHONE = Pattern.compile("^(1)\\d{10}$");

    public static boolean match(String value, String regularExp) {
        return ValidatorUtil.isEmpty(value) ? false : Pattern.compile(regularExp).matcher(value).matches();
    }

    public static boolean isNumeric(String value) {
        return ValidatorUtil.isEmpty(value) ? false : PATTERN_NUMERIC.matcher(value).matches();
    }

    public static boolean isEmail(String value) {
        return ValidatorUtil.isEmpty(value) ? false : PATTERN_EMAIL.matcher(value).matches();
    }

    public static boolean isMobile(String value) {
        return ValidatorUtil.isEmpty(value) ? false : PATTERN_MOBILE_PHONE.matcher(value).matches();
    }

    public static boolean isNumber(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String value) {
        return null == value || "".equals(value.trim()) || "null".equalsIgnoreCase(value.trim());
    }

    private ValidatorUtil() {
    }
}

