/*
 * Decompiled with CFR 0.152.
 */
package com.wuwenze.poi.xlsx;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wuwenze.poi.config.Options;
import com.wuwenze.poi.convert.ReadConverter;
import com.wuwenze.poi.exception.ExcelKitEncounterNoNeedXmlException;
import com.wuwenze.poi.exception.ExcelKitReadConverterException;
import com.wuwenze.poi.exception.ExcelKitRuntimeException;
import com.wuwenze.poi.handler.ExcelReadHandler;
import com.wuwenze.poi.pojo.ExcelErrorField;
import com.wuwenze.poi.pojo.ExcelMapping;
import com.wuwenze.poi.pojo.ExcelProperty;
import com.wuwenze.poi.util.BeanUtil;
import com.wuwenze.poi.util.Const;
import com.wuwenze.poi.util.DateUtil;
import com.wuwenze.poi.util.POIUtil;
import com.wuwenze.poi.util.RegexUtil;
import com.wuwenze.poi.util.ValidatorUtil;
import com.wuwenze.poi.validator.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelXlsxReader
extends DefaultHandler {
    private Integer mCurrentSheetIndex = -1;
    private Integer mCurrentRowIndex = 0;
    private Integer mCurrentCellIndex = 0;
    private ExcelCellType mNextCellType = ExcelCellType.STRING;
    private String mCurrentCellRef;
    private String mPreviousCellRef;
    private String mMaxCellRef;
    private SharedStringsTable mSharedStringsTable;
    private String mPreviousCellValue;
    private StylesTable mStylesTable;
    private Boolean mNextIsString = false;
    private Short mFormatIndex;
    private String mFormatString;
    private final ExcelMapping mExcelMapping;
    private final ExcelReadHandler mExcelReadHandler;
    private final Class<? extends Object> mEntityClass;
    private final List<Object> mExcelRowObjectData = Lists.newArrayList();
    private Integer mBeginReadRowIndex = Const.XLSX_DEFAULT_BEGIN_READ_ROW_INDEX;
    private final Object mEmptyCellValue = "$EMPTY_CELL$";
    private static final String CHECK_MAP_KEY_OF_VALUE = "CELL_VALUE";
    private static final String CHECK_MAP_KEY_OF_ERROR = "CELL_ERROR";

    public ExcelXlsxReader(Class<? extends Object> entityClass, ExcelMapping excelMapping, ExcelReadHandler excelReadHandler) {
        this(entityClass, excelMapping, null, excelReadHandler);
    }

    public ExcelXlsxReader(Class<? extends Object> entityClass, ExcelMapping excelMapping, Integer beginReadRowIndex, ExcelReadHandler excelReadHandler) {
        this.mEntityClass = entityClass;
        this.mExcelMapping = excelMapping;
        if (null != beginReadRowIndex) {
            this.mBeginReadRowIndex = beginReadRowIndex;
        }
        this.mExcelReadHandler = excelReadHandler;
    }

    public void process(String fileName) throws ExcelKitRuntimeException {
        try {
            this.processAll(OPCPackage.open((String)fileName));
        }
        catch (Exception e) {
            throw new ExcelKitRuntimeException("Only .xlsx formatted files are supported.", e);
        }
    }

    public void process(InputStream in) throws ExcelKitRuntimeException {
        try {
            this.processAll(OPCPackage.open((InputStream)in));
        }
        catch (Exception e) {
            throw new ExcelKitRuntimeException("Only .xlsx formatted files are supported.", e);
        }
    }

    private void processAll(OPCPackage pkg) throws IOException, OpenXML4JException, SAXException {
        XSSFReader xssfReader = new XSSFReader(pkg);
        this.mStylesTable = xssfReader.getStylesTable();
        SharedStringsTable sst = xssfReader.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(sst);
        Iterator sheets = xssfReader.getSheetsData();
        while (sheets.hasNext()) {
            this.mCurrentRowIndex = 0;
            Integer n = this.mCurrentSheetIndex;
            Integer n2 = this.mCurrentSheetIndex = Integer.valueOf(this.mCurrentSheetIndex + 1);
            InputStream sheet = (InputStream)sheets.next();
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            sheet.close();
        }
        pkg.close();
    }

    public void process(String fileName, int sheetIndex) throws ExcelKitRuntimeException {
        try {
            this.processBySheet(sheetIndex, OPCPackage.open((String)fileName));
        }
        catch (Exception e) {
            throw new ExcelKitRuntimeException("Only .xlsx formatted files are supported.", e);
        }
    }

    public void process(InputStream in, int sheetIndex) throws ExcelKitRuntimeException {
        try {
            this.processBySheet(sheetIndex, OPCPackage.open((InputStream)in));
        }
        catch (Exception e) {
            throw new ExcelKitRuntimeException("Only .xlsx formatted files are supported.", e);
        }
    }

    private void processBySheet(int sheetIndex, OPCPackage pkg) throws IOException, OpenXML4JException, SAXException {
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable sst = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(sst);
        InputStream sheet = r.getSheet("rId" + (sheetIndex + 1));
        Integer n = this.mCurrentSheetIndex;
        Integer n2 = this.mCurrentSheetIndex = Integer.valueOf(this.mCurrentSheetIndex + 1);
        InputSource sheetSource = new InputSource(sheet);
        try {
            parser.parse(sheetSource);
        }
        catch (ExcelKitEncounterNoNeedXmlException e) {
            sheet = r.getSheet("rId" + (sheetIndex + 3));
            sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
        }
        sheet.close();
        pkg.close();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("sst".equals(name) || "styleSheet".equals(name)) {
            throw new ExcelKitEncounterNoNeedXmlException();
        }
        if ("c".equals(name)) {
            String ref = attributes.getValue("r");
            this.mPreviousCellRef = null == this.mPreviousCellRef ? ref : this.mCurrentCellRef;
            this.mCurrentCellRef = ref;
            String cellType = attributes.getValue("t");
            String cellStyleStr = attributes.getValue("s");
            this.mNextIsString = null != cellType && cellType.equals("s");
            this.setNextCellType(cellType, cellStyleStr);
        }
        this.mPreviousCellValue = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String name) {
        if (this.mNextIsString.booleanValue()) {
            int index = Integer.parseInt(this.mPreviousCellValue);
            this.mPreviousCellValue = new XSSFRichTextString(this.mSharedStringsTable.getEntryAt(index)).toString();
            this.mNextIsString = false;
        }
        if ("c".equals(name)) {
            Integer n;
            String value = this.getCellValue(this.mPreviousCellValue.trim());
            if (!this.mCurrentCellRef.equals(this.mPreviousCellRef)) {
                for (int i = 0; i < POIUtil.countNullCell(this.mCurrentCellRef, this.mPreviousCellRef); ++i) {
                    this.mExcelRowObjectData.add(this.mCurrentCellIndex, this.mEmptyCellValue);
                    n = this.mCurrentCellIndex;
                    Integer n2 = this.mCurrentCellIndex = Integer.valueOf(this.mCurrentCellIndex + 1);
                }
            }
            this.mExcelRowObjectData.add(this.mCurrentCellIndex, value);
            Integer n3 = this.mCurrentCellIndex;
            n = this.mCurrentCellIndex = Integer.valueOf(this.mCurrentCellIndex + 1);
        } else if ("row".equals(name)) {
            Integer n;
            if (this.mCurrentRowIndex == 0) {
                this.mMaxCellRef = this.mCurrentCellRef;
            }
            if (null != this.mMaxCellRef) {
                for (int i = 0; i <= POIUtil.countNullCell(this.mMaxCellRef, this.mCurrentCellRef); ++i) {
                    this.mExcelRowObjectData.add(this.mCurrentCellIndex, this.mEmptyCellValue);
                    n = this.mCurrentCellIndex;
                    Integer n4 = this.mCurrentCellIndex = Integer.valueOf(this.mCurrentCellIndex + 1);
                }
            }
            try {
                this.performVerificationAndProcessFlowRow();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mExcelRowObjectData.clear();
                Integer n5 = this.mCurrentRowIndex;
                n = this.mCurrentRowIndex = Integer.valueOf(this.mCurrentRowIndex + 1);
                this.mCurrentCellIndex = 0;
                this.mPreviousCellRef = null;
                this.mCurrentCellRef = null;
            }
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        this.mPreviousCellValue = this.mPreviousCellValue.concat(new String(chars, start, length));
    }

    private XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.mSharedStringsTable = sst;
        parser.setContentHandler(this);
        return parser;
    }

    private void setNextCellType(String cellType, String cellStyleStr) {
        this.mNextCellType = ExcelCellType.STRING;
        this.mFormatIndex = -1;
        this.mFormatString = null;
        if ("b".equals(cellType)) {
            this.mNextCellType = ExcelCellType.BOOL;
        } else if ("e".equals(cellType)) {
            this.mNextCellType = ExcelCellType.ERROR;
        } else if ("inlineStr".equals(cellType)) {
            this.mNextCellType = ExcelCellType.INLINESTR;
        } else if ("s".equals(cellType)) {
            this.mNextCellType = ExcelCellType.STRING;
        } else if ("str".equals(cellType)) {
            this.mNextCellType = ExcelCellType.FORMULA;
        }
        if (null != cellStyleStr) {
            int styleIndex = Integer.parseInt(cellStyleStr);
            XSSFCellStyle style = this.mStylesTable.getStyleAt(styleIndex);
            this.mFormatIndex = style.getDataFormat();
            this.mFormatString = style.getDataFormatString();
            if (null == this.mFormatString) {
                this.mNextCellType = ExcelCellType.NULL;
                this.mFormatString = BuiltinFormats.getBuiltinFormat((int)this.mFormatIndex.shortValue());
            }
        }
    }

    private String getCellValue(String value) {
        switch (this.mNextCellType) {
            case BOOL: {
                return value.charAt(0) == '0' ? "FALSE" : "TRUE";
            }
            case ERROR: {
                return "\"ERROR:" + value + '\"';
            }
            case FORMULA: {
                return '\"' + value + '\"';
            }
            case INLINESTR: {
                return new XSSFRichTextString(value).toString();
            }
            case STRING: {
                return String.valueOf(value);
            }
        }
        return value;
    }

    private void performVerificationAndProcessFlowRow() throws Exception {
        if (this.mCurrentRowIndex >= this.mBeginReadRowIndex) {
            List<ExcelProperty> propertyList = this.mExcelMapping.getPropertyList();
            Integer excelRowDataSize = this.mExcelRowObjectData.size();
            Integer excelMappingPropertySize = propertyList.size();
            for (int i = 0; i < excelMappingPropertySize - excelRowDataSize; ++i) {
                this.mExcelRowObjectData.add(i, this.mEmptyCellValue);
            }
            if (!this.rowObjectDataIsAllEmptyCellValue()) {
                Object entity = this.mEntityClass.newInstance();
                ArrayList errorFields = Lists.newArrayList();
                for (int i = 0; i < propertyList.size(); ++i) {
                    ExcelProperty property = propertyList.get(i);
                    Map<String, Object> checkAndConvertPropertyRetMap = this.checkAndConvertProperty(i, property, this.mExcelRowObjectData.get(i));
                    Object errorFieldObject = checkAndConvertPropertyRetMap.get(CHECK_MAP_KEY_OF_ERROR);
                    if (null != errorFieldObject) {
                        errorFields.add((ExcelErrorField)errorFieldObject);
                    }
                    if (!errorFields.isEmpty()) continue;
                    Object propertyValue = checkAndConvertPropertyRetMap.get(CHECK_MAP_KEY_OF_VALUE);
                    BeanUtil.setComplexProperty(entity, property.getName(), propertyValue);
                }
                if (errorFields.isEmpty()) {
                    this.mExcelReadHandler.onSuccess(this.mCurrentSheetIndex, this.mCurrentRowIndex, entity);
                    return;
                }
                this.mExcelReadHandler.onError(this.mCurrentSheetIndex, this.mCurrentRowIndex, errorFields);
            }
        }
    }

    private boolean rowObjectDataIsAllEmptyCellValue() {
        int emptyObjectCount = 0;
        for (Object excelRowObjectData : this.mExcelRowObjectData) {
            if (null != excelRowObjectData && !excelRowObjectData.equals(this.mEmptyCellValue) && !ValidatorUtil.isEmpty((String)excelRowObjectData)) continue;
            ++emptyObjectCount;
        }
        return emptyObjectCount == this.mExcelRowObjectData.size();
    }

    private Map<String, Object> checkAndConvertProperty(Integer cellIndex, ExcelProperty property, Object propertyValue) {
        String validErrorMessage;
        String regularExp;
        String[] values;
        Boolean required = property.getRequired();
        if (null != required && required.booleanValue() && (null == propertyValue || ValidatorUtil.isEmpty((String)propertyValue) || "$EMPTY_CELL$".equals(propertyValue))) {
            return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, propertyValue, "\u5355\u5143\u683c\u7684\u503c\u5fc5\u987b\u586b\u5199");
        }
        Integer maxLength = property.getMaxLength();
        if (-1 != maxLength && null != propertyValue && !this.mEmptyCellValue.equals(propertyValue) && String.valueOf(propertyValue).length() > maxLength) {
            return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, propertyValue, "\u8d85\u8fc7\u6700\u5927\u957f\u5ea6: " + maxLength);
        }
        String dateFormat = property.getDateFormat();
        if (!ValidatorUtil.isEmpty(dateFormat)) {
            try {
                Date parseDateValue = DateUtil.parse(dateFormat, propertyValue);
                return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, parseDateValue, null);
            }
            catch (Exception e) {
                return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, propertyValue, "\u65f6\u95f4\u683c\u5f0f\u89e3\u6790\u5931\u8d25 [" + dateFormat + "]");
            }
        }
        Options options = property.getOptions();
        if (null != options && null != (values = options.get()) && values.length > 0) {
            boolean containInOptions = false;
            for (String value : values) {
                if (!propertyValue.equals(value)) continue;
                containInOptions = true;
                break;
            }
            if (!containInOptions) {
                return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, propertyValue, "[" + propertyValue + "]\u4e0d\u662f\u89c4\u5b9a\u7684\u4e0b\u62c9\u6846\u7684\u503c");
            }
        }
        if (!ValidatorUtil.isEmpty(regularExp = property.getRegularExp()) && !RegexUtil.isMatches(regularExp, propertyValue).booleanValue()) {
            String regularExpMessage = property.getRegularExpMessage();
            validErrorMessage = !ValidatorUtil.isEmpty(regularExpMessage) ? regularExpMessage : "\u6b63\u5219\u8868\u8fbe\u5f0f\u6821\u9a8c\u5931\u8d25 [" + regularExp + "]";
            return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, propertyValue, validErrorMessage);
        }
        Validator validator = property.getValidator();
        if (null != validator && null != (validErrorMessage = validator.valid(propertyValue))) {
            return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, propertyValue, validErrorMessage);
        }
        String readConverterExp = property.getReadConverterExp();
        ReadConverter readConverter = property.getReadConverter();
        if (!ValidatorUtil.isEmpty(readConverterExp)) {
            try {
                Object convertPropertyValue = POIUtil.convertByExp(propertyValue, readConverterExp);
                return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, convertPropertyValue, null);
            }
            catch (Exception e) {
                return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, propertyValue, "\u7531\u4e8ereadConverterExp\u8868\u8fbe\u5f0f\u7684\u503c\u4e0d\u89c4\u8303\u5bfc\u81f4\u8f6c\u6362\u5931\u8d25");
            }
        }
        if (null != readConverter) {
            try {
                return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, readConverter.convert(propertyValue), null);
            }
            catch (ExcelKitReadConverterException e) {
                return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, propertyValue, e.getMessage());
            }
        }
        return this.buildCheckAndConvertPropertyRetMap(cellIndex, property, propertyValue, null);
    }

    private Map<String, Object> buildCheckAndConvertPropertyRetMap(Integer cellIndex, ExcelProperty property, Object propertyValue, String validErrorMessage) {
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(CHECK_MAP_KEY_OF_VALUE, propertyValue);
        if (null != validErrorMessage) {
            resultMap.put(CHECK_MAP_KEY_OF_ERROR, ExcelErrorField.builder().cellIndex(cellIndex).column(property.getColumn()).name(property.getName()).errorMessage(validErrorMessage).build());
        }
        return resultMap;
    }

    static enum ExcelCellType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        STRING,
        NUMBER,
        DATE,
        NULL;

    }
}

