/*
 * Decompiled with CFR 0.152.
 */
package com.wuwenze.poi.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutionException;

public class DateUtil {
    public static final SimpleDateFormat ENGLISH_LOCAL_DF = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
    private static final LoadingCache<String, SimpleDateFormat> mDateFormatLoadingCache = CacheBuilder.newBuilder().maximumSize(5L).build((CacheLoader)new CacheLoader<String, SimpleDateFormat>(){

        public SimpleDateFormat load(String pattern) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            simpleDateFormat.setLenient(true);
            return simpleDateFormat;
        }
    });

    public static Date parse(String pattern, Object value) throws Exception {
        String valueString = (String)value;
        return ((SimpleDateFormat)mDateFormatLoadingCache.get((Object)pattern)).parse(valueString);
    }

    public static String format(String pattern, Date value) {
        try {
            return ((SimpleDateFormat)mDateFormatLoadingCache.get((Object)pattern)).format(value);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return value.toString();
        }
    }

    private DateUtil() {
    }
}

