/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.bean;

import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.BeanUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.StrUtil;

public class BeanResolver {
    private static final char[] expChars = new char[]{'.', '[', ']'};
    private Object bean;
    private String expression;

    public static Object resolveBean(Object bean, String expression) {
        return new BeanResolver(bean, expression).resolve();
    }

    public BeanResolver(Object bean, String expression) {
        this.bean = bean;
        this.expression = expression;
    }

    public Object resolve() {
        Object subBean = this.bean;
        int length = this.expression.length();
        StringBuilder sb = new StringBuilder();
        boolean isNumStart = false;
        boolean isFirst = true;
        for (int i = 0; i < length; ++i) {
            char c = this.expression.charAt(i);
            if (ArrayUtil.contains(expChars, c)) {
                String name;
                if (']' == c) {
                    if (!isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format((CharSequence)"Bad expression '{}':{}, we find ']' but no '[' !", this.expression, i));
                    }
                    isNumStart = false;
                } else {
                    if (isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format((CharSequence)"Bad expression '{}':{}, we find '[' but no ']' !", this.expression, i));
                    }
                    if ('[' == c) {
                        isNumStart = true;
                    }
                }
                if (sb.length() > 0 && null == (subBean = this.getSubBean(subBean, name = sb.toString()))) {
                    if (isFirst && ClassUtil.getClassName(this.bean, true).equals(StrUtil.upperFirst(name))) {
                        subBean = this.bean;
                        isFirst = false;
                    } else {
                        return null;
                    }
                }
                sb = new StringBuilder();
                continue;
            }
            if (isNumStart && (c < '0' || c > '9')) {
                throw new IllegalArgumentException(StrUtil.format((CharSequence)"Bad expression '{}':{}, it must number between '[' and ']', but contains '{}' !", this.expression, i, Character.valueOf(c)));
            }
            sb.append(c);
        }
        if (isNumStart) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Bad expression '{}':{}, we find '[' but no ']' !", this.expression, length - 1));
        }
        if (sb.length() > 0) {
            subBean = this.getSubBean(subBean, sb.toString());
        }
        return subBean;
    }

    private Object getSubBean(Object bean, String name) {
        return BeanUtil.getFieldValue(bean, name);
    }
}

