/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.io.file;

import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.io.LineHandler;
import com.xiaoleilu.hutool.io.file.FileWrapper;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileReader
extends FileWrapper {
    public static FileReader create(File file, Charset charset) {
        return new FileReader(file, charset);
    }

    public static FileReader create(File file) {
        return new FileReader(file);
    }

    public FileReader(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileReader(File file, String charset) {
        this(file, CharsetUtil.charset(charset));
    }

    public FileReader(String filePath, Charset charset) {
        this(FileUtil.file(filePath), charset);
    }

    public FileReader(String filePath, String charset) {
        this(FileUtil.file(filePath), CharsetUtil.charset(charset));
    }

    public FileReader(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public FileReader(String filePath) {
        this(filePath, DEFAULT_CHARSET);
    }

    public byte[] readBytes() throws IORuntimeException {
        long len = this.file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new IORuntimeException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            int readLength = in.read(bytes);
            if ((long)readLength < len) {
                throw new IOException(StrUtil.format((CharSequence)"File length is [{}] but read [{}]!", len, readLength));
            }
        }
        catch (Exception e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return bytes;
    }

    public String readString() throws IORuntimeException {
        return new String(this.readBytes(), this.charset);
    }

    public <T extends Collection<String>> T readLines(T collection) throws IORuntimeException {
        T t;
        BufferedReader reader = null;
        try {
            String line;
            reader = FileUtil.getReader(this.file, this.charset);
            while ((line = reader.readLine()) != null) {
                collection.add((String)line);
            }
            t = collection;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(reader);
                throw throwable;
            }
        }
        IoUtil.close(reader);
        return t;
    }

    public void readLines(LineHandler lineHandler) throws IORuntimeException {
        BufferedReader reader = null;
        try {
            reader = FileUtil.getReader(this.file, this.charset);
            IoUtil.readLines((Reader)reader, lineHandler);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(reader);
                throw throwable;
            }
        }
        IoUtil.close(reader);
    }

    public List<String> readLines() throws IORuntimeException {
        return this.readLines(new ArrayList());
    }

    public <T> T read(ReaderHandler<T> readerHandler) throws IORuntimeException {
        BufferedReader reader = null;
        T result = null;
        try {
            reader = FileUtil.getReader(this.file, this.charset);
            result = readerHandler.handle(reader);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(reader);
                throw throwable;
            }
        }
        IoUtil.close(reader);
        return result;
    }

    public BufferedReader getReader() throws IORuntimeException {
        return IoUtil.getReader((InputStream)this.getInputStream(), this.charset);
    }

    public BufferedInputStream getInputStream() throws IORuntimeException {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public File writeToStream(OutputStream out) throws IORuntimeException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            IoUtil.copy((InputStream)in, out);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return this.file;
    }

    private void checkFile() throws IORuntimeException {
        if (!this.file.exists()) {
            throw new IORuntimeException("File not exist: " + this.file);
        }
        if (!this.file.isFile()) {
            throw new IORuntimeException("Not a file:" + this.file);
        }
    }

    public static interface ReaderHandler<T> {
        public T handle(BufferedReader var1) throws IOException;
    }
}

