/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.lang.Base64;
import com.xiaoleilu.hutool.util.CharsetUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtil {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";

    private ImageUtil() {
    }

    public static final void scale(File srcImageFile, File destImageFile, int scale, boolean flag) {
        try {
            ImageUtil.scale(ImageIO.read(srcImageFile), ImageIO.createImageOutputStream(destImageFile), scale, flag);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void scale(InputStream srcStream, OutputStream destStream, int scale, boolean flag) {
        try {
            ImageUtil.scale(ImageIO.read(srcStream), ImageIO.createImageOutputStream(destStream), scale, flag);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void scale(ImageInputStream srcStream, ImageOutputStream destStream, int scale, boolean flag) {
        try {
            ImageUtil.scale(ImageIO.read(srcStream), destStream, scale, flag);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void scale(Image srcImg, ImageOutputStream destImageStream, int scale, boolean flag) {
        try {
            BufferedImage src = ImageUtil.toBufferedImage(srcImg);
            int width = src.getWidth();
            int height = src.getHeight();
            if (flag) {
                width *= scale;
                height *= scale;
            } else {
                width /= scale;
                height /= scale;
            }
            Image image = src.getScaledInstance(width, height, 1);
            ImageIO.write((RenderedImage)ImageUtil.toBufferedImage(image), IMAGE_TYPE_JPEG, destImageStream);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void scale(File srcImageFile, File destImageFile, int height, int width, Color fixedColor) {
        try {
            ImageUtil.scale(ImageIO.read(srcImageFile), ImageIO.createImageOutputStream(destImageFile), height, width, fixedColor);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void scale(InputStream srcStream, OutputStream destStream, int height, int width, Color fixedColor) {
        try {
            ImageUtil.scale(ImageIO.read(srcStream), ImageIO.createImageOutputStream(destStream), height, width, fixedColor);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void scale(ImageInputStream srcStream, ImageOutputStream destStream, int height, int width, Color fixedColor) {
        try {
            ImageUtil.scale(ImageIO.read(srcStream), destStream, height, width, fixedColor);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void scale(Image srcImage, ImageOutputStream destImageStream, int height, int width, Color fixedColor) {
        try {
            double ratio = 0.0;
            BufferedImage bi = ImageUtil.toBufferedImage(srcImage);
            Image itemp = bi.getScaledInstance(width, height, 4);
            if (bi.getHeight() > height || bi.getWidth() > width) {
                ratio = bi.getHeight() > bi.getWidth() ? (double)height / (double)bi.getHeight() : (double)width / (double)bi.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                itemp = op.filter(bi, null);
            }
            if (null != fixedColor) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(fixedColor);
                g.fillRect(0, 0, width, height);
                int itempHeight = itemp.getHeight(null);
                int itempWidth = itemp.getWidth(null);
                if (width == itempWidth) {
                    g.drawImage(itemp, 0, (height - itempHeight) / 2, itempWidth, itempHeight, fixedColor, null);
                } else {
                    g.drawImage(itemp, (width - itempWidth) / 2, 0, itempWidth, itempHeight, fixedColor, null);
                }
                g.dispose();
                itemp = image;
            }
            ImageIO.write((RenderedImage)ImageUtil.toBufferedImage(itemp), IMAGE_TYPE_JPEG, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void cut(File srcImgFile, File destImgFile, int x, int y, int width, int height) {
        try {
            ImageUtil.cut(ImageIO.read(srcImgFile), ImageIO.createImageOutputStream(destImgFile), x, y, width, height);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void cut(InputStream srcStream, OutputStream destStream, int x, int y, int width, int height) {
        try {
            ImageUtil.cut(ImageIO.read(srcStream), ImageIO.createImageOutputStream(destStream), x, y, width, height);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void cut(ImageInputStream srcStream, ImageOutputStream destStream, int x, int y, int width, int height) {
        try {
            ImageUtil.cut(ImageIO.read(srcStream), destStream, x, y, width, height);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void cut(Image srcImage, ImageOutputStream destImageStream, int x, int y, int width, int height) {
        try {
            BufferedImage bi = ImageUtil.toBufferedImage(srcImage);
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > 0 && srcHeight > 0) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                CropImageFilter cropFilter = new CropImageFilter(x, y, width, height);
                Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                BufferedImage tag = new BufferedImage(width, height, 1);
                Graphics g = tag.getGraphics();
                g.drawImage(img, 0, 0, width, height, null);
                g.dispose();
                ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, destImageStream);
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static final void slice(File srcImageFile, File descDir, int destWidth, int destHeight) {
        try {
            ImageUtil.slice(ImageIO.read(srcImageFile), descDir, destWidth, destHeight);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void slice(Image srcImage, File descDir, int destWidth, int destHeight) {
        try {
            if (destWidth <= 0) {
                destWidth = 200;
            }
            if (destHeight <= 0) {
                destHeight = 150;
            }
            BufferedImage bi = ImageUtil.toBufferedImage(srcImage);
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > destWidth && srcHeight > destHeight) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                int cols = 0;
                int rows = 0;
                cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor(srcWidth / destWidth) + 1;
                rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor(srcHeight / destHeight) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        CropImageFilter cropFilter = new CropImageFilter(j * destWidth, i * destHeight, destWidth, destHeight);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(destWidth, destHeight, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        ImageIO.write((RenderedImage)tag, "JPEG", new File(descDir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void sliceByRowsAndCols(File srcImageFile, File descDir, int rows, int cols) {
        try {
            ImageUtil.sliceByRowsAndCols(ImageIO.read(srcImageFile), descDir, rows, cols);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void sliceByRowsAndCols(Image srcImage, File descDir, int rows, int cols) {
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImageUtil.toBufferedImage(srcImage);
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > 0 && srcHeight > 0) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                int destWidth = srcWidth;
                int destHeight = srcHeight;
                destWidth = srcWidth % cols == 0 ? srcWidth / cols : (int)Math.floor(srcWidth / cols) + 1;
                destHeight = srcHeight % rows == 0 ? srcHeight / rows : (int)Math.floor(srcWidth / rows) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        CropImageFilter cropFilter = new CropImageFilter(j * destWidth, i * destHeight, destWidth, destHeight);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(destWidth, destHeight, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, new File(descDir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static final void convert(File srcImageFile, String formatName, File destImageFile) {
        try {
            ImageUtil.convert(ImageIO.read(srcImageFile), formatName, ImageIO.createImageOutputStream(destImageFile));
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        try {
            ImageUtil.convert(ImageIO.read(srcStream), formatName, ImageIO.createImageOutputStream(destStream));
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void convert(ImageInputStream srcStream, String formatName, ImageOutputStream destStream) {
        try {
            ImageUtil.convert(ImageIO.read(srcStream), formatName, destStream);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void convert(Image srcImage, String formatName, ImageOutputStream destImageStream) {
        try {
            ImageIO.write((RenderedImage)ImageUtil.toBufferedImage(srcImage), formatName, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void gray(File srcImageFile, File destImageFile) {
        try {
            ImageUtil.gray(ImageIO.read(srcImageFile), ImageIO.createImageOutputStream(destImageFile));
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void gray(InputStream srcStream, OutputStream destStream) {
        try {
            ImageUtil.gray(ImageIO.read(srcStream), ImageIO.createImageOutputStream(destStream));
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void gray(ImageInputStream srcStream, ImageOutputStream destStream) {
        try {
            ImageUtil.gray(ImageIO.read(srcStream), destStream);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void gray(Image srcImage, ImageOutputStream destImageStream) {
        try {
            BufferedImage src = ImageUtil.toBufferedImage(srcImage);
            ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            src = op.filter(src, null);
            ImageIO.write((RenderedImage)src, IMAGE_TYPE_JPEG, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void pressText(File srcFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        try {
            ImageUtil.pressText(ImageIO.read(srcFile), ImageIO.createImageOutputStream(destFile), pressText, color, font, x, y, alpha);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        try {
            ImageUtil.pressText(ImageIO.read(srcStream), ImageIO.createImageOutputStream(destStream), pressText, color, font, x, y, alpha);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        try {
            ImageUtil.pressText(ImageIO.read(srcStream), destStream, pressText, color, font, x, y, alpha);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        try {
            BufferedImage src = ImageUtil.toBufferedImage(srcImage);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.setColor(color);
            g.setFont(font);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            int fontSize = font.getSize();
            g.drawString(pressText, (width - ImageUtil.getLength(pressText) * fontSize) / 2 + x, (height - fontSize) / 2 + y);
            g.dispose();
            ImageIO.write((RenderedImage)image, IMAGE_TYPE_JPEG, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void pressImage(File srcImageFile, File destImageFile, Image pressImg, int x, int y, float alpha) {
        try {
            ImageUtil.pressImage(ImageIO.read(srcImageFile), ImageIO.createImageOutputStream(destImageFile), pressImg, x, y, alpha);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void pressImage(InputStream srcStream, OutputStream destStream, Image pressImg, int x, int y, float alpha) {
        try {
            ImageUtil.pressImage(ImageIO.read(srcStream), ImageIO.createImageOutputStream(destStream), pressImg, x, y, alpha);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImg, int x, int y, float alpha) {
        try {
            ImageUtil.pressImage(ImageIO.read(srcStream), destStream, pressImg, x, y, alpha);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImg, int x, int y, float alpha) {
        try {
            BufferedImage src = ImageUtil.toBufferedImage(srcImage);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            int pressImgWidth = pressImg.getWidth(null);
            int pressImgHeight = pressImg.getHeight(null);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawImage(pressImg, x += (width - pressImgWidth) / 2, y += (height - pressImgHeight) / 2, pressImgWidth, pressImgHeight, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, IMAGE_TYPE_JPEG, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage toImage(String base64) throws IORuntimeException {
        byte[] decode = Base64.decode(base64, CharsetUtil.CHARSET_UTF_8);
        return ImageUtil.toImage(decode);
    }

    public static BufferedImage toImage(byte[] imageBytes) throws IORuntimeException {
        try {
            return ImageIO.read(new ByteArrayInputStream(imageBytes));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void createImage(String str, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) throws UtilException {
        Rectangle2D r = font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics g = image.getGraphics();
        g.setColor(backgroundColor);
        g.fillRect(0, 0, width, height);
        g.setColor(fontColor);
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        try {
            ImageIO.write((RenderedImage)image, IMAGE_TYPE_PNG, out);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static Font createFont(File fontFile) {
        try {
            return Font.createFont(0, fontFile);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontFile);
            }
            catch (Exception e1) {
                throw new UtilException(e);
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static Font createFont(InputStream fontStream) {
        try {
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontStream);
            }
            catch (Exception e1) {
                throw new UtilException(e);
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    private static final int getLength(String text) {
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (new String(text.charAt(i) + "").getBytes().length > 1) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length / 2;
    }
}

