/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cache.file;

import com.xiaoleilu.hutool.cache.Cache;
import com.xiaoleilu.hutool.cache.file.AbstractFileCache;
import com.xiaoleilu.hutool.cache.impl.LFUCache;
import java.io.File;

public class LFUFileCache
extends AbstractFileCache {
    public LFUFileCache(int capacity) {
        this(capacity, capacity / 2, 0L);
    }

    public LFUFileCache(int capacity, int maxFileSize) {
        this(capacity, maxFileSize, 0L);
    }

    public LFUFileCache(int capacity, int maxFileSize, long timeout) {
        super(capacity, maxFileSize, timeout);
    }

    @Override
    protected Cache<File, byte[]> initCache() {
        LFUCache<File, byte[]> cache = new LFUCache<File, byte[]>(this.capacity, this.timeout){

            @Override
            public boolean isFull() {
                return LFUFileCache.this.usedSize > this.capacity;
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                LFUFileCache.this.usedSize -= cachedObject.length;
            }
        };
        return cache;
    }
}

