/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.exceptions.NotInitedException;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.NetUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;

public class MongoDS
implements Closeable {
    private static final Log log = StaticLog.get();
    public static final String MONGO_CONFIG_PATH = "config/mongo.setting";
    private static final String GROUP_SEPRATER = ",";
    private static Map<String, MongoDS> dsMap = new HashMap<String, MongoDS>();
    private Setting setting;
    private String[] groups;
    private ServerAddress serverAddress;
    private MongoClient mongo;

    public static MongoDS getDS(String host, int port) {
        String key = host + ":" + port;
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(host, port);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(String ... groups) {
        String key = ArrayUtil.join(groups, (CharSequence)GROUP_SEPRATER);
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(groups);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Collection<String> groups) {
        return MongoDS.getDS(groups.toArray(new String[groups.size()]));
    }

    public static MongoDS getDS(Setting setting, String ... groups) {
        String key = setting.getSettingPath() + GROUP_SEPRATER + ArrayUtil.join(groups, (CharSequence)GROUP_SEPRATER);
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(setting, groups);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Setting setting, Collection<String> groups) {
        return MongoDS.getDS(setting, groups.toArray(new String[groups.size()]));
    }

    public static void closeAll() {
        if (CollectionUtil.isNotEmpty(dsMap)) {
            for (MongoDS ds : dsMap.values()) {
                ds.close();
            }
            dsMap.clear();
        }
    }

    public MongoDS(String host, int port) {
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(Setting mongoSetting, String host, int port) {
        this.setting = mongoSetting;
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(String ... groups) {
        this.groups = groups;
        this.init();
    }

    public MongoDS(Setting mongoSetting, String ... groups) {
        if (mongoSetting == null) {
            throw new DbRuntimeException("Mongo setting is null!");
        }
        this.setting = mongoSetting;
        this.groups = groups;
        this.init();
    }

    public void init() {
        if (this.groups != null && this.groups.length > 1) {
            this.initCloud();
        } else {
            this.initSingle();
        }
    }

    public synchronized void initSingle() {
        if (this.setting == null) {
            try {
                this.setting = new Setting(MONGO_CONFIG_PATH, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String group = "";
        if (this.serverAddress == null) {
            if (this.groups != null && this.groups.length == 1) {
                group = this.groups[0];
            }
            this.serverAddress = this.createServerAddress(group);
        }
        try {
            this.mongo = new MongoClient(this.serverAddress, this.buildMongoClientOptions(group));
        }
        catch (Exception e) {
            throw new DbRuntimeException(StrUtil.format((CharSequence)"Init MongoDB pool with connection to [{}] error!", this.serverAddress), e);
        }
        log.info("Init MongoDB pool with connection to [{}]", this.serverAddress);
    }

    public synchronized void initCloud() {
        if (this.groups == null || this.groups.length == 0) {
            throw new DbRuntimeException("Please give replication set groups!");
        }
        if (this.setting == null) {
            this.setting = new Setting(MONGO_CONFIG_PATH, true);
        }
        ArrayList<ServerAddress> addrList = new ArrayList<ServerAddress>();
        for (String group : this.groups) {
            addrList.add(this.createServerAddress(group));
        }
        try {
            this.mongo = new MongoClient(addrList, this.buildMongoClientOptions(""));
        }
        catch (Exception e) {
            log.error(e, "Init MongoDB connection error!", new Object[0]);
            return;
        }
        log.info("Init MongoDB cloud Set pool with connection to {}", addrList);
    }

    public void setSetting(Setting setting) {
        this.setting = setting;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public MongoDatabase getDb(String dbName) {
        return this.mongo.getDatabase(dbName);
    }

    public MongoCollection<Document> getCollection(String dbName, String collectionName) {
        return this.getDb(dbName).getCollection(collectionName);
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    private ServerAddress createServerAddress(String group) {
        String tmpHost;
        if (this.setting == null) {
            throw new DbRuntimeException(StrUtil.format((CharSequence)"Please indicate setting file or create default [{}], and define group [{}]", MONGO_CONFIG_PATH, group));
        }
        if (group == null) {
            group = "";
        }
        if (StrUtil.isBlank(tmpHost = this.setting.getByGroup("host", group))) {
            throw new NotInitedException("Host name is empy of group: " + group);
        }
        int defaultPort = this.setting.getInt("port", group, 27017);
        return new ServerAddress(NetUtil.buildInetSocketAddress(tmpHost, defaultPort));
    }

    private ServerAddress createServerAddress(String host, int port) {
        return new ServerAddress(host, port);
    }

    private MongoClientOptions buildMongoClientOptions(String group) {
        return this.buildMongoClientOptions(MongoClientOptions.builder(), group).build();
    }

    private MongoClientOptions.Builder buildMongoClientOptions(MongoClientOptions.Builder builder, String group) {
        if (this.setting == null) {
            return builder;
        }
        group = group == null ? "" : group + ".";
        Integer connectionsPerHost = this.setting.getInt(group + "connectionsPerHost");
        if (!StrUtil.isBlank(group) && connectionsPerHost == null) {
            connectionsPerHost = this.setting.getInt("connectionsPerHost");
        }
        if (connectionsPerHost != null) {
            builder.connectionsPerHost(connectionsPerHost.intValue());
            log.debug("MongoDB connectionsPerHost: {}", connectionsPerHost);
        }
        Integer threadsAllowedToBlockForConnectionMultiplier = this.setting.getInt(group + "threadsAllowedToBlockForConnectionMultiplier");
        if (!StrUtil.isBlank(group) && threadsAllowedToBlockForConnectionMultiplier == null) {
            threadsAllowedToBlockForConnectionMultiplier = this.setting.getInt("threadsAllowedToBlockForConnectionMultiplier");
        }
        if (threadsAllowedToBlockForConnectionMultiplier != null) {
            builder.threadsAllowedToBlockForConnectionMultiplier(threadsAllowedToBlockForConnectionMultiplier.intValue());
            log.debug("MongoDB threadsAllowedToBlockForConnectionMultiplier: {}", threadsAllowedToBlockForConnectionMultiplier);
        }
        Integer connectTimeout = this.setting.getInt(group + "connectTimeout");
        if (!StrUtil.isBlank(group) && connectTimeout == null) {
            this.setting.getInt("connectTimeout");
        }
        if (connectTimeout != null) {
            builder.connectTimeout(connectTimeout.intValue());
            log.debug("MongoDB connectTimeout: {}", connectTimeout);
        }
        Integer socketTimeout = this.setting.getInt(group + "socketTimeout");
        if (!StrUtil.isBlank(group) && socketTimeout == null) {
            this.setting.getInt("socketTimeout");
        }
        if (socketTimeout != null) {
            builder.socketTimeout(socketTimeout.intValue());
            log.debug("MongoDB socketTimeout: {}", socketTimeout);
        }
        return builder;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MongoDS.closeAll();
            }
        });
    }
}

