/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.extra.servlet;

import com.xiaoleilu.hutool.bean.BeanUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.ReflectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtil {
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";

    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : ServletUtil.getParams(request).entrySet()) {
            params.put(entry.getKey(), ArrayUtil.join((Object[])entry.getValue(), (CharSequence)","));
        }
        return params;
    }

    public static <T> T fillBean(final ServletRequest request, T bean, BeanUtil.CopyOptions copyOptions) {
        final String beanName = StrUtil.lowerFirst(bean.getClass().getSimpleName());
        return BeanUtil.fillBean(bean, new BeanUtil.ValueProvider<String>(){

            @Override
            public Object value(String key, Type valueType) {
                String value = request.getParameter(key);
                if (StrUtil.isEmpty(value) && StrUtil.isEmpty(value = request.getParameter(beanName + "." + key))) {
                    value = null;
                }
                return value;
            }

            @Override
            public boolean containsKey(String key) {
                return null != request.getParameter(key);
            }
        }, copyOptions);
    }

    public static <T> T fillBean(ServletRequest request, T bean, boolean isIgnoreError) {
        return ServletUtil.fillBean(request, bean, BeanUtil.CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T toBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return ServletUtil.fillBean(request, ReflectUtil.newInstance(beanClass, new Object[0]), isIgnoreError);
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String ip;
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty(otherHeaderNames)) {
            headers = ArrayUtil.addAll(headers, otherHeaderNames);
        }
        for (String header : headers) {
            ip = request.getHeader(header);
            if (ServletUtil.isUnknow(ip)) continue;
            return ServletUtil.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return ServletUtil.getMultistageReverseProxyIp(ip);
    }

    public static final String getHeaderIgnoreCase(HttpServletRequest request, String nameIgnoreCase) {
        Enumeration names = request.getHeaderNames();
        String name = null;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            if (name == null || !name.equalsIgnoreCase(nameIgnoreCase)) continue;
            return request.getHeader(name);
        }
        return null;
    }

    public static final String getHeader(HttpServletRequest request, String name, String charset) {
        String header = request.getHeader(name);
        if (null != header) {
            try {
                return new String(header.getBytes("ISO-8859-1"), charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new UtilException(StrUtil.format((CharSequence)"Error charset {} for http request header.", charset));
            }
        }
        return null;
    }

    public static boolean isIE(HttpServletRequest request) {
        String userAgent = ServletUtil.getHeaderIgnoreCase(request, "User-Agent");
        return StrUtil.isNotBlank(userAgent) && ((userAgent = userAgent.toUpperCase()).contains("MSIE") || userAgent.contains("TRIDENT"));
    }

    public static boolean isGetMethod(HttpServletRequest request) {
        return METHOD_GET.equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPostMethod(HttpServletRequest request) {
        return METHOD_POST.equalsIgnoreCase(request.getMethod());
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!ServletUtil.isPostMethod(request)) {
            return false;
        }
        String contentType = request.getContentType();
        if (StrUtil.isBlank(contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static final Cookie getCookie(HttpServletRequest httpServletRequest, String name) {
        Map<String, Cookie> cookieMap = ServletUtil.readCookieMap(httpServletRequest);
        return cookieMap == null ? null : cookieMap.get(name);
    }

    public static final Map<String, Cookie> readCookieMap(HttpServletRequest httpServletRequest) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = httpServletRequest.getCookies();
        if (null == cookies) {
            return null;
        }
        for (Cookie cookie : cookies) {
            cookieMap.put(cookie.getName().toLowerCase(), cookie);
        }
        return cookieMap;
    }

    public static final void addCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static final void addCookie(HttpServletResponse response, String name, String value) {
        response.addCookie(new Cookie(name, value));
    }

    public static final void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        ServletUtil.addCookie(response, cookie);
    }

    public static final void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        ServletUtil.addCookie(response, name, value, maxAgeInSeconds, "/", null);
    }

    public static PrintWriter getWriter(HttpServletResponse response) throws IORuntimeException {
        try {
            return response.getWriter();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void write(HttpServletResponse response, String text, String contentType) {
        response.setContentType(contentType);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            ((Writer)writer).write(text);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            IoUtil.close(writer);
        }
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType) {
        response.setContentType(contentType);
        ServletUtil.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in) {
        ServletUtil.write(response, in, 1024);
    }

    public static void write(HttpServletResponse response, InputStream in, int bufferSize) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            IoUtil.copy(in, (OutputStream)out, bufferSize);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            IoUtil.close((Closeable)out);
            IoUtil.close(in);
        }
    }

    public static void setHeader(HttpServletResponse response, String name, Object value) {
        if (value instanceof String) {
            response.setHeader(name, (String)value);
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            response.setDateHeader(name, ((Date)value).getTime());
        } else if (value instanceof Integer || "int".equals(value.getClass().getSimpleName().toLowerCase())) {
            response.setIntHeader(name, ((Integer)value).intValue());
        } else {
            response.setHeader(name, value.toString());
        }
    }

    private static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (ServletUtil.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    private static boolean isUnknow(String checkString) {
        return StrUtil.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }
}

