/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.poi.excel;

import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.poi.excel.ExcelReader;
import com.xiaoleilu.hutool.poi.excel.ExcelWriter;
import com.xiaoleilu.hutool.poi.excel.sax.Excel03SaxReader;
import com.xiaoleilu.hutool.poi.excel.sax.Excel07SaxReader;
import com.xiaoleilu.hutool.poi.excel.sax.handler.RowHandler;
import com.xiaoleilu.hutool.poi.exceptions.POIException;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    public static void readBySax(String path, int sheetIndex, RowHandler rowHandler) {
        ExcelUtil.readBySax(FileUtil.getInputStream(path), sheetIndex, rowHandler);
    }

    public static void readBySax(File file, int sheetIndex, RowHandler rowHandler) {
        ExcelUtil.readBySax(FileUtil.getInputStream(file), sheetIndex, rowHandler);
    }

    public static void readBySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        if (ExcelUtil.isXlsx(in)) {
            ExcelUtil.read07BySax(in, sheetIndex, rowHandler);
        } else {
            ExcelUtil.read03BySax(in, sheetIndex, rowHandler);
        }
    }

    public static Excel07SaxReader read07BySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        return new Excel07SaxReader(rowHandler).read(in, sheetIndex);
    }

    public static Excel07SaxReader read07BySax(File file, int sheetIndex, RowHandler rowHandler) {
        return new Excel07SaxReader(rowHandler).read(file, sheetIndex);
    }

    public static Excel07SaxReader read07BySax(String path, int sheetIndex, RowHandler rowHandler) {
        return (Excel07SaxReader)new Excel07SaxReader(rowHandler).read(path, sheetIndex);
    }

    public static Excel03SaxReader read03BySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        return new Excel03SaxReader(rowHandler).read(in, sheetIndex);
    }

    public static Excel03SaxReader read03BySax(File file, int sheetIndex, RowHandler rowHandler) {
        return new Excel03SaxReader(rowHandler).read(file, sheetIndex);
    }

    public static Excel03SaxReader read03BySax(String path, int sheetIndex, RowHandler rowHandler) {
        return (Excel03SaxReader)new Excel03SaxReader(rowHandler).read(path, sheetIndex);
    }

    public static ExcelReader getReader(String bookFilePath) {
        return ExcelUtil.getReader(bookFilePath, 0);
    }

    public static ExcelReader getReader(File bookFile) {
        return ExcelUtil.getReader(bookFile, 0);
    }

    public static ExcelReader getReader(String bookFilePath, int sheetIndex) {
        return new ExcelReader(bookFilePath, sheetIndex);
    }

    public static ExcelReader getReader(File bookFile, int sheetIndex) {
        return new ExcelReader(bookFile, sheetIndex);
    }

    public static ExcelReader getReader(File bookFile, String sheetName) {
        return new ExcelReader(bookFile, sheetName);
    }

    public static ExcelReader getReader(InputStream bookStream) {
        return ExcelUtil.getReader(bookStream, 0);
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex) {
        return new ExcelReader(bookStream, sheetIndex);
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName) {
        return new ExcelReader(bookStream, sheetName);
    }

    public static Workbook loadBook(String excelFilePath) {
        return ExcelUtil.loadBook(FileUtil.file(excelFilePath), null);
    }

    public static Workbook loadBook(File excelFile) {
        return ExcelUtil.loadBook(excelFile, null);
    }

    public static Workbook loadBook(File excelFile, String password) {
        try {
            return WorkbookFactory.create((File)excelFile, (String)password);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public static Workbook loadBook(InputStream in) {
        try {
            return WorkbookFactory.create((InputStream)in);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public static Workbook createBook(String destFilePath) {
        Object workbook = StrUtil.endWithIgnoreCase(destFilePath, "xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
        return workbook;
    }

    public static Workbook createBook(File destFile) {
        return ExcelUtil.createBook(destFile.getName());
    }

    public static void writeBook(Workbook book, OutputStream out) throws IORuntimeException {
        try {
            book.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ExcelWriter getWriter() {
        return new ExcelWriter();
    }

    public static ExcelWriter getWriter(boolean isXlsx) {
        return new ExcelWriter(isXlsx);
    }

    public static ExcelWriter getWriter(String destFilePath) {
        return new ExcelWriter(destFilePath);
    }

    public static ExcelWriter getWriter(File destFile) {
        return new ExcelWriter(destFile);
    }

    public static ExcelWriter getWriter(String destFilePath, String sheetName) {
        return new ExcelWriter(destFilePath, sheetName);
    }

    public static ExcelWriter getWriter(File destFile, String sheetName) {
        return new ExcelWriter(destFile, sheetName);
    }

    public static boolean isXls(InputStream in) {
        PushbackInputStream pin = IoUtil.toPushbackStream(in, 8);
        try {
            return POIFSFileSystem.hasPOIFSHeader((InputStream)pin);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean isXlsx(InputStream in) {
        PushbackInputStream pin = IoUtil.toPushbackStream(in, 8);
        try {
            return DocumentFactoryHelper.hasOOXMLHeader((InputStream)pin);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

