/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cache.file;

import com.xiaoleilu.hutool.cache.Cache;
import com.xiaoleilu.hutool.cache.file.AbstractFileCache;
import com.xiaoleilu.hutool.cache.impl.LRUCache;
import java.io.File;

public class LRUFileCache
extends AbstractFileCache {
    public LRUFileCache(int capacity) {
        this(capacity, capacity / 2, 0L);
    }

    public LRUFileCache(int capacity, int maxFileSize) {
        this(capacity, maxFileSize, 0L);
    }

    public LRUFileCache(int capacity, int maxFileSize, long timeout) {
        super(capacity, maxFileSize, timeout);
    }

    @Override
    protected Cache<File, byte[]> initCache() {
        LRUCache<File, byte[]> cache = new LRUCache<File, byte[]>(this.capacity, this.timeout){

            @Override
            public boolean isFull() {
                return LRUFileCache.this.usedSize > this.capacity;
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                LRUFileCache.this.usedSize -= cachedObject.length;
            }
        };
        return cache;
    }
}

