/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert;

public class NumberChineseFormater {
    private static final String[] simpleDigits = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] traditionalDigits = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};

    public static String format(double amount, boolean isUserTraditional) {
        String[] numArray;
        String[] stringArray = numArray = isUserTraditional ? traditionalDigits : simpleDigits;
        if (amount > 9.999999999999998E13 || amount < -9.999999999999998E13) {
            throw new IllegalArgumentException("\u53c2\u6570\u503c\u8d85\u51fa\u5141\u8bb8\u8303\u56f4 (-99999999999999.99 \uff5e 99999999999999.99)\uff01");
        }
        boolean negative = false;
        if (amount < 0.0) {
            negative = true;
            amount *= -1.0;
        }
        long temp = Math.round(amount * 100.0);
        int numFen = (int)(temp % 10L);
        int numJiao = (int)((temp /= 10L) % 10L);
        temp /= 10L;
        int[] parts = new int[20];
        int numParts = 0;
        int i = 0;
        while (temp != 0L) {
            int part;
            parts[i] = part = (int)(temp % 10000L);
            ++numParts;
            temp /= 10000L;
            ++i;
        }
        boolean beforeWanIsZero = true;
        String chineseStr = "";
        for (int i2 = 0; i2 < numParts; ++i2) {
            String partChinese = NumberChineseFormater.toChinese(parts[i2], numArray);
            if (i2 % 2 == 0) {
                beforeWanIsZero = "".equals(partChinese);
            }
            if (i2 != 0) {
                if (i2 % 2 == 0) {
                    chineseStr = "\u4ebf" + chineseStr;
                } else if ("".equals(partChinese) && !beforeWanIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                } else {
                    if (parts[i2 - 1] < 1000 && parts[i2 - 1] > 0) {
                        chineseStr = "\u96f6" + chineseStr;
                    }
                    chineseStr = "\u4e07" + chineseStr;
                }
            }
            chineseStr = partChinese + chineseStr;
        }
        if ("".equals(chineseStr)) {
            chineseStr = numArray[0];
        } else if (negative) {
            chineseStr = "\u8d1f" + chineseStr;
        }
        chineseStr = chineseStr + "";
        chineseStr = numFen == 0 && numJiao == 0 ? chineseStr + "" : (numFen == 0 ? chineseStr + "\u70b9" + numArray[numJiao] + "" : (numJiao == 0 ? chineseStr + "\u70b9\u96f6" + numArray[numFen] + "" : chineseStr + "\u70b9" + numArray[numJiao] + numArray[numFen] + ""));
        return chineseStr;
    }

    private static String toChinese(int amountPart, String[] numArray) {
        if (amountPart < 0 || amountPart > 10000) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u662f\u5927\u4e8e\u7b49\u4e8e 0\uff0c\u5c0f\u4e8e 10000 \u7684\u6574\u6570\uff01");
        }
        String[] units = new String[]{"", "\u5341", "\u767e", "\u5343"};
        int temp = amountPart;
        String amountStr = new Integer(amountPart).toString();
        int amountStrLength = amountStr.length();
        boolean lastIsZero = true;
        String chineseStr = "";
        for (int i = 0; i < amountStrLength && temp != 0; temp /= 10, ++i) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                }
                lastIsZero = true;
                continue;
            }
            chineseStr = numArray[digit] + units[i] + chineseStr;
            lastIsZero = false;
        }
        return chineseStr;
    }

    public static void main(String[] args) {
        System.out.println("-----------\u6570\u5b57\u6d4b\u7b97\u5f00\u59cb--------------");
        System.out.println("10889.72356: " + NumberChineseFormater.format(10889.72356, false));
        System.out.println("12653: " + NumberChineseFormater.format(12653.0, false));
        System.out.println("215.6387: " + NumberChineseFormater.format(215.6387, false));
        System.out.println("1024: " + NumberChineseFormater.format(1024.0, false));
        System.out.println("100350089: " + NumberChineseFormater.format(1.00350089E8, false));
        System.out.println("1200: " + NumberChineseFormater.format(1200.0, false));
        System.out.println("12: " + NumberChineseFormater.format(12.0, false));
        System.out.println("1.05: " + NumberChineseFormater.format(0.05, false));
        System.out.println("-----------\u6570\u5b57\u6d4b\u7b97\u7ed3\u675f--------------");
        System.out.println("-----------\u6570\u5b57\u6d4b\u7b97\u5f00\u59cb--------------");
        System.out.println("10889.72356: " + NumberChineseFormater.format(10889.72356, true));
        System.out.println("12653: " + NumberChineseFormater.format(12653.0, true));
        System.out.println("215.6387: " + NumberChineseFormater.format(215.6387, true));
        System.out.println("1024: " + NumberChineseFormater.format(1024.0, true));
        System.out.println("100350089: " + NumberChineseFormater.format(1.00350089E8, true));
        System.out.println("1200: " + NumberChineseFormater.format(1200.0, true));
        System.out.println("12: " + NumberChineseFormater.format(12.0, true));
        System.out.println("1.05: " + NumberChineseFormater.format(0.05, true));
        System.out.println("-----------\u6570\u5b57\u6d4b\u7b97\u7ed3\u675f--------------");
    }
}

