/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.handler;

import com.xiaoleilu.hutool.db.Entity;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;

public class HandleHelper {
    public static Entity handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs) throws SQLException {
        return HandleHelper.handleRow(Entity.create(), columnCount, meta, rs);
    }

    public static <T extends Entity> T handleRow(T row, int columnCount, ResultSetMetaData meta, ResultSet rs) throws SQLException {
        row.setTableName(meta.getTableName(1));
        for (int i = 1; i <= columnCount; ++i) {
            String columnLabel = meta.getColumnLabel(i);
            int type = meta.getColumnType(i);
            row.put(columnLabel, HandleHelper.getColumnValue(rs, columnLabel, type));
        }
        return row;
    }

    public static Entity handleRow(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        return HandleHelper.handleRow(columnCount, meta, rs);
    }

    public static <T extends Collection<Entity>> T handleRs(ResultSet rs, T collection) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            collection.add((Entity)HandleHelper.handleRow(columnCount, meta, rs));
        }
        return collection;
    }

    public static <E, T extends Collection<E>> T handleRsToBeanList(ResultSet rs, T collection, Class<E> elementBeanType) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            collection.add(HandleHelper.handleRow(columnCount, meta, rs).toBean(elementBeanType));
        }
        return collection;
    }

    private static Object getColumnValue(ResultSet rs, String label, int type) throws SQLException {
        switch (type) {
            case 93: {
                return rs.getTimestamp(label);
            }
            case 92: {
                return rs.getTime(label);
            }
        }
        return rs.getObject(label);
    }
}

