/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class BoundedPriorityQueue<E>
extends PriorityQueue<E> {
    private static final long serialVersionUID = 3794348988671694820L;
    private int capacity;
    private Comparator<? super E> comparator;

    public BoundedPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public BoundedPriorityQueue(int capacity, final Comparator<? super E> comparator) {
        super(capacity, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                int cResult = 0;
                if (comparator != null) {
                    cResult = comparator.compare(o1, o2);
                } else {
                    Comparable o1c = (Comparable)o1;
                    cResult = o1c.compareTo(o2);
                }
                return -cResult;
            }
        });
        this.capacity = capacity;
        this.comparator = comparator;
    }

    @Override
    public boolean offer(E e) {
        if (this.size() >= this.capacity) {
            Object head = this.peek();
            if (this.comparator().compare(e, head) <= 0) {
                return true;
            }
            this.poll();
        }
        return super.offer(e);
    }

    public boolean addAll(E[] c) {
        return this.addAll(Arrays.asList(c));
    }

    public ArrayList<E> toList() {
        ArrayList list = new ArrayList(this);
        Collections.sort(list, this.comparator);
        return list;
    }

    @Override
    public Iterator<E> iterator() {
        return this.toList().iterator();
    }
}

