/*
 * Decompiled with CFR 0.152.
 */
package com.mg.swagger.controller;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.mg.swagger.framework.json.MgUiResponseJson;
import com.mg.swagger.framework.json.ResponseJson;
import com.mg.swagger.framework.service.MgStorageService;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.swagger.web.SwaggerResource;

@RestController
@RequestMapping(value={"/swagger-mg-ui/document"})
public class MgDocumentController {
    @Autowired(required=false)
    private MgStorageService storageService;

    @ResponseBody
    @PostMapping(value={"/resourcesList"})
    public ResponseJson resourcesList() {
        if (this.storageService == null) {
            return MgUiResponseJson.warn("\u6682\u672a\u914d\u7f6eMgStorageService\u7684\u5b9e\u73b0\u7c7b");
        }
        String swaggerResourcesStr = this.storageService.get("swagger-resources-list");
        HashSet resourcesSet = new HashSet();
        if (StringUtils.isNotBlank((String)swaggerResourcesStr)) {
            List resourcesList = JSON.parseArray((String)swaggerResourcesStr, String.class);
            resourcesSet.addAll(resourcesList);
        }
        return MgUiResponseJson.ok(resourcesSet);
    }

    @ResponseBody
    @PostMapping(value={"/docs"})
    public void docs(HttpServletRequest request, HttpServletResponse response) {
        if (this.storageService == null) {
            MgUiResponseJson.warn("\u6682\u672a\u914d\u7f6eMgStorageService\u7684\u5b9e\u73b0\u7c7b").send(response);
            return;
        }
        boolean needRestorage = true;
        String choiseDocList = request.getParameter("choiseDocList");
        HashSet<String> resourcesSet = new HashSet<String>();
        HashSet swaggerDocsDeleteSet = new HashSet();
        if (StringUtils.isNotBlank((String)choiseDocList)) {
            needRestorage = false;
            resourcesSet.addAll(Arrays.asList(choiseDocList.split(",")));
        } else {
            String swaggerResourcesStr = this.storageService.get("swagger-resources-list");
            String swaggerDocsDeleteStr = this.storageService.get("swagger-docs-delete-list");
            if (StringUtils.isNotBlank((String)swaggerResourcesStr)) {
                List resourcesList = JSON.parseArray((String)swaggerResourcesStr, String.class);
                resourcesSet.addAll(resourcesList);
            } else {
                String serverPath = "http://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
                resourcesSet.add(serverPath + "/swagger-resources");
            }
            if (StringUtils.isNotBlank((String)swaggerDocsDeleteStr)) {
                List swaggerDocsDeleteList = JSON.parseArray((String)swaggerDocsDeleteStr, String.class);
                swaggerDocsDeleteSet.addAll(swaggerDocsDeleteList);
            }
        }
        LinkedList<Map> swaggerResourceList = new LinkedList<Map>();
        LinkedList<String> swaggerResourceStrList = new LinkedList<String>();
        for (String resourcesUrl : resourcesSet) {
            List resourceList = null;
            try {
                String resourcesStr = HttpRequest.get((String)resourcesUrl).timeout(3000).execute().body();
                resourceList = JSON.parseArray((String)resourcesStr, SwaggerResource.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (resourceList == null || resourceList.isEmpty()) continue;
            resourcesUrl = resourcesUrl.substring(0, resourcesUrl.lastIndexOf("/") + 1);
            for (SwaggerResource resource : resourceList) {
                String location = resource.getLocation();
                String string = location = location.startsWith("/") ? location.replaceFirst("/", "") : location;
                if (location.indexOf("?") >= 0) {
                    try {
                        String encode = URLEncoder.encode(resource.getName(), "utf-8");
                        location = location.substring(0, location.lastIndexOf("?")) + "?group=" + encode;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (swaggerDocsDeleteSet.contains(location = resourcesUrl + location)) continue;
                try {
                    String resourceStr = HttpRequest.get((String)location).timeout(3000).execute().body();
                    Map jsonObject = (Map)JSON.parseObject((String)resourceStr, (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                    if (jsonObject == null || jsonObject.isEmpty()) continue;
                    jsonObject.put("fullUrl", location);
                    swaggerResourceList.add(jsonObject);
                    resourceStr = resourceStr.substring(1);
                    resourceStr = "{\"fullUrl\":\"" + location + "\",\"domainUrl\":\"" + resourcesUrl + "\"," + resourceStr;
                    swaggerResourceStrList.add(resourceStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (needRestorage) {
            this.storageService.put("swagger-resources-list", JSON.toJSONString(resourcesSet));
        }
        MgUiResponseJson.ok(swaggerResourceStrList).send(response);
    }

    @PostMapping(value={"/addSwaggerResources"})
    public ResponseJson addSwaggerResources(String resourcesUrl) {
        if (this.storageService == null) {
            return MgUiResponseJson.warn("\u6682\u672a\u914d\u7f6eMgStorageService\u7684\u5b9e\u73b0\u7c7b");
        }
        String swaggerResourcesStr = this.storageService.get("swagger-resources-list");
        String swaggerDocsDeleteStr = this.storageService.get("swagger-docs-delete-list");
        HashSet swaggerDocsDeleteSet = new HashSet();
        if (StringUtils.isNotBlank((String)swaggerDocsDeleteStr)) {
            List swaggerDocsDeleteList = JSON.parseArray((String)swaggerDocsDeleteStr, String.class);
            swaggerDocsDeleteSet.addAll(swaggerDocsDeleteList);
        }
        HashSet<String> resourcesSet = new HashSet<String>();
        if (StringUtils.isNotBlank((String)swaggerResourcesStr)) {
            List resourcesList = JSON.parseArray((String)swaggerResourcesStr, String.class);
            resourcesSet.addAll(resourcesList);
        }
        try {
            String resourcesStr = HttpRequest.get((String)resourcesUrl).timeout(3000).execute().body();
            List resourceList = JSON.parseArray((String)resourcesStr, SwaggerResource.class);
            if (resourceList == null || resourceList.isEmpty()) {
                return MgUiResponseJson.warn("\u6539\u5730\u5740\u672a\u627e\u5230\u6587\u6863");
            }
            String resourcesDomain = resourcesUrl.substring(0, resourcesUrl.lastIndexOf("/") + 1);
            for (SwaggerResource swaggerResource : resourceList) {
                String location = swaggerResource.getLocation();
                String string = location = location.startsWith("/") ? location.replaceFirst("/", "") : location;
                if (location.indexOf("?") >= 0) {
                    try {
                        String encode = URLEncoder.encode(swaggerResource.getName(), "utf-8");
                        location = location.substring(0, location.lastIndexOf("?")) + "?group=" + encode;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                location = resourcesDomain + location;
                swaggerDocsDeleteSet.remove(location);
            }
            resourcesSet.add(resourcesUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return MgUiResponseJson.warn("\u6539\u5730\u5740\u67e5\u627e\u6587\u6863\u5931\u8d25");
        }
        this.storageService.put("swagger-resources-list", JSON.toJSONString(resourcesSet));
        this.storageService.put("swagger-docs-delete-list", JSON.toJSONString(swaggerDocsDeleteSet));
        return MgUiResponseJson.ok();
    }

    @PostMapping(value={"/deleteSwaggerDoc"})
    public ResponseJson deleteSwaggerDoc(String docUrl) {
        if (this.storageService == null) {
            return MgUiResponseJson.warn("\u6682\u672a\u914d\u7f6eMgStorageService\u7684\u5b9e\u73b0\u7c7b");
        }
        String swaggerDocsDeleteStr = this.storageService.get("swagger-docs-delete-list");
        HashSet<String> swaggerDocsDeleteSet = new HashSet<String>();
        if (StringUtils.isNotBlank((String)swaggerDocsDeleteStr)) {
            List swaggerDocsDeleteList = JSON.parseArray((String)swaggerDocsDeleteStr, String.class);
            swaggerDocsDeleteSet.addAll(swaggerDocsDeleteList);
        }
        swaggerDocsDeleteSet.add(docUrl);
        this.storageService.put("swagger-docs-delete-list", JSON.toJSONString(swaggerDocsDeleteSet));
        return MgUiResponseJson.ok();
    }
}

