/*
 * Decompiled with CFR 0.152.
 */
package com.mg.swagger.framework.json;

import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import com.mg.swagger.controller.vo.HttpCookieVo;
import com.mg.swagger.controller.vo.HttpHeaderVo;
import com.mg.swagger.framework.json.ResponseJson;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class MgUiResponseJson
implements ResponseJson {
    private static SerializeConfig mapping = new SerializeConfig();
    @ApiModelProperty(value="\u72b6\u6001\u7801")
    private Integer errCode;
    @ApiModelProperty(value="\u8fd4\u56de\u503c\u8bf4\u660e")
    private String errMsg;
    @ApiModelProperty(value="\u8fd4\u56de\u6570\u636e")
    private Object data;
    @ApiModelProperty(value="\u4ee3\u7406\u8bf7\u6c42\u8fd4\u56de\u7684cookie")
    private List<HttpCookieVo> cookie;
    @ApiModelProperty(value="\u4ee3\u7406\u8bf7\u6c42\u8fd4\u56de\u7684header")
    private List<HttpHeaderVo> header;
    @ApiModelProperty(value="\u4ee3\u7406\u8bf7\u6c42\u8fd4\u56de\u7684status")
    private Integer status;

    public MgUiResponseJson() {
        this.errCode = 200;
    }

    public MgUiResponseJson(Object data) {
        this.setData(data);
        this.errCode = 200;
    }

    public MgUiResponseJson(int errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public MgUiResponseJson(int errCode, String errMsg, Object data) {
        this.setData(data);
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public MgUiResponseJson(Integer errCode) {
        this.errCode = errCode;
    }

    public Integer getErrCode() {
        return this.errCode;
    }

    public void setErrCode(Integer errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public static MgUiResponseJson warn(String errMsg) {
        return new MgUiResponseJson(300, errMsg);
    }

    public static MgUiResponseJson error(String errMsg) {
        return new MgUiResponseJson(500, errMsg);
    }

    public static MgUiResponseJson ok() {
        return new MgUiResponseJson();
    }

    public static MgUiResponseJson ok(Object data) {
        if (data == null) {
            return MgUiResponseJson.ok();
        }
        MgUiResponseJson responseJson = new MgUiResponseJson();
        if (data instanceof HttpResponse) {
            Map headers;
            HttpResponse response = (HttpResponse)data;
            responseJson.setData(response.body());
            responseJson.setStatus(response.getStatus());
            List cookies = response.getCookies();
            if (cookies != null && cookies.size() > 0) {
                ArrayList<HttpCookieVo> cookie = new ArrayList<HttpCookieVo>(cookies.size());
                for (HttpCookie httpCookie : cookies) {
                    HttpCookieVo vo = new HttpCookieVo();
                    vo.setName(httpCookie.getName());
                    vo.setValue(httpCookie.getValue());
                    cookie.add(vo);
                }
                responseJson.setCookie(cookie);
            }
            if ((headers = response.headers()) != null && headers.size() > 0) {
                ArrayList<HttpHeaderVo> header = new ArrayList<HttpHeaderVo>(headers.size());
                for (Map.Entry httpHeader : headers.entrySet()) {
                    HttpHeaderVo vo = new HttpHeaderVo();
                    vo.setName((String)httpHeader.getKey());
                    vo.setValue(String.join((CharSequence)";", (Iterable)httpHeader.getValue()));
                    header.add(vo);
                }
                responseJson.setHeader(header);
            }
        } else {
            responseJson.setData(data);
        }
        return responseJson;
    }

    public String toJson() {
        return JSON.toJSONString((Object)this, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[0]);
    }

    public void send(HttpServletResponse response) {
        try {
            response.setStatus(200);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Cache-Control", "no-cache, must-revalidate");
            response.getWriter().write(this.toJson());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "DefaultResponseJson [errCode=" + this.errCode + ", errMsg=" + this.errMsg + ", data=" + this.data + "]";
    }

    public List<HttpCookieVo> getCookie() {
        return this.cookie;
    }

    public void setCookie(List<HttpCookieVo> cookie) {
        this.cookie = cookie;
    }

    public List<HttpHeaderVo> getHeader() {
        return this.header;
    }

    public void setHeader(List<HttpHeaderVo> header) {
        this.header = header;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    static {
        mapping.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
    }
}

