/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.List;
import java.util.Objects;

public class Metadata {
    private final ChatMessage chatMessage;
    private final Object chatMemoryId;
    private final List<ChatMessage> chatMemory;

    public Metadata(ChatMessage chatMessage, Object chatMemoryId, List<ChatMessage> chatMemory) {
        this.chatMessage = ValidationUtils.ensureNotNull(chatMessage, "chatMessage");
        this.chatMemoryId = chatMemoryId;
        this.chatMemory = Utils.copy(chatMemory);
    }

    public ChatMessage chatMessage() {
        return this.chatMessage;
    }

    public Object chatMemoryId() {
        return this.chatMemoryId;
    }

    public List<ChatMessage> chatMemory() {
        return this.chatMemory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.chatMessage, that.chatMessage) && Objects.equals(this.chatMemoryId, that.chatMemoryId) && Objects.equals(this.chatMemory, that.chatMemory);
    }

    public int hashCode() {
        return Objects.hash(this.chatMessage, this.chatMemoryId, this.chatMemory);
    }

    public String toString() {
        return "Metadata { chatMessage = " + String.valueOf(this.chatMessage) + ", chatMemoryId = " + String.valueOf(this.chatMemoryId) + ", chatMemory = " + String.valueOf(this.chatMemory) + " }";
    }

    public static Metadata from(ChatMessage chatMessage, Object chatMemoryId, List<ChatMessage> chatMemory) {
        return new Metadata(chatMessage, chatMemoryId, chatMemory);
    }
}

