/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.spring;

import dev.langchain4j.service.spring.AiService;
import dev.langchain4j.service.spring.ClassPathAiServiceScanner;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class AiServiceScannerProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private Environment environment;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ClassPathAiServiceScanner classPathAiServiceScanner = new ClassPathAiServiceScanner(registry, false);
        Set<String> basePackages = this.getBasePackages((ConfigurableListableBeanFactory)registry);
        for (String basePackage : basePackages) {
            classPathAiServiceScanner.scan(new String[]{basePackage});
        }
        this.removeAiServicesWithInactiveProfiles(registry);
    }

    private Set<String> getBasePackages(ConfigurableListableBeanFactory beanFactory) {
        Class applicationBeanClass;
        SpringBootApplication springBootApplication;
        String[] beanNames;
        LinkedHashSet<String> basePackages = new LinkedHashSet<String>();
        List autoConfigPackages = AutoConfigurationPackages.get((BeanFactory)beanFactory);
        basePackages.addAll(autoConfigPackages);
        for (String beanName : beanNames = beanFactory.getBeanNamesForAnnotation(ComponentScan.class)) {
            ComponentScan componentScan;
            Class beanClass = beanFactory.getType(beanName);
            if (beanClass == null || (componentScan = beanClass.getAnnotation(ComponentScan.class)) == null) continue;
            Collections.addAll(basePackages, componentScan.value());
            Collections.addAll(basePackages, componentScan.basePackages());
            for (Class basePackageClass : componentScan.basePackageClasses()) {
                basePackages.add(basePackageClass.getPackage().getName());
            }
        }
        String[] applicationBeans = beanFactory.getBeanNamesForAnnotation(SpringBootApplication.class);
        if (applicationBeans.length > 0 && (springBootApplication = (SpringBootApplication)AnnotationUtils.findAnnotation((Class)(applicationBeanClass = beanFactory.getType(applicationBeans[0])), SpringBootApplication.class)) != null) {
            Collections.addAll(basePackages, springBootApplication.scanBasePackages());
            for (Class aClass : springBootApplication.scanBasePackageClasses()) {
                basePackages.add(ClassUtils.getPackageName((Class)aClass));
            }
        }
        return basePackages;
    }

    private void removeAiServicesWithInactiveProfiles(BeanDefinitionRegistry registry) {
        Arrays.stream(registry.getBeanDefinitionNames()).filter(beanName -> {
            try {
                Class<?> beanClass;
                BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
                if (beanDefinition.getBeanClassName() != null && (beanClass = Class.forName(beanDefinition.getBeanClassName())).isAnnotationPresent(AiService.class) && beanClass.isAnnotationPresent(Profile.class)) {
                    Profile profileAnnotation = beanClass.getAnnotation(Profile.class);
                    String[] profiles = profileAnnotation.value();
                    return !this.environment.matchesProfiles(profiles);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return false;
        }).forEach(arg_0 -> ((BeanDefinitionRegistry)registry).removeBeanDefinition(arg_0));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

