/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.util.Collections;
import java.util.List;
import net.dongliu.requests.Cookie;
import net.dongliu.requests.Header;
import net.dongliu.requests.Headers;
import org.checkerframework.checker.nullness.qual.Nullable;

class AbstractResponse {
    protected final String url;
    protected final int statusCode;
    protected final List<Cookie> cookies;
    protected final Headers headers;

    protected AbstractResponse(String url, int statusCode, List<Cookie> cookies, Headers headers) {
        this.url = url;
        this.statusCode = statusCode;
        this.cookies = Collections.unmodifiableList(cookies);
        this.headers = headers;
    }

    @Deprecated
    public String getURL() {
        return this.url;
    }

    public String url() {
        return this.url;
    }

    @Deprecated
    public int getStatusCode() {
        return this.statusCode;
    }

    public int statusCode() {
        return this.statusCode;
    }

    @Deprecated
    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public List<Cookie> cookies() {
        return this.cookies;
    }

    @Deprecated
    public List<Header> getHeaders() {
        return this.headers.getHeaders();
    }

    public List<Header> headers() {
        return this.headers.getHeaders();
    }

    @Deprecated
    public @Nullable Cookie getFirstCookie(String name) {
        return this.getCookie(name);
    }

    public @Nullable Cookie getCookie(String name) {
        for (Cookie cookie : this.cookies) {
            if (!cookie.name().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    @Deprecated
    public @Nullable String getFirstHeader(String name) {
        return this.headers.getFirstHeader(name);
    }

    public @Nullable String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public List<String> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }
}

