/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dongliu.commons.Lazy;
import net.dongliu.commons.collection.Lists;
import net.dongliu.requests.Header;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Headers
implements Serializable {
    private static final long serialVersionUID = -1283402589869346874L;
    private final List<Header> headers;
    private final transient Lazy<Map<String, List<String>>> lazyMap;

    public Headers(List<Header> headers) {
        this.headers = Lists.copy(Objects.requireNonNull(headers));
        this.lazyMap = Lazy.of(() -> Headers.toMap(headers));
    }

    private static Map<String, List<String>> toMap(List<Header> headers) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry entry : headers) {
            String key = ((String)entry.getKey()).toLowerCase();
            String value = (String)entry.getValue();
            ArrayList<String> list = (ArrayList<String>)map.get(key);
            if (list == null) {
                list = new ArrayList<String>(4);
                list.add(value);
                map.put(key, list);
                continue;
            }
            list.add(value);
        }
        return map;
    }

    public List<String> getHeaders(String name) {
        Objects.requireNonNull(name);
        List values = (List)((Map)this.lazyMap.get()).get(name.toLowerCase());
        if (values == null) {
            return Lists.of();
        }
        return Collections.unmodifiableList(values);
    }

    @Deprecated
    public @Nullable String getFirstHeader(String name) {
        Objects.requireNonNull(name);
        return this.getHeader(name);
    }

    public @Nullable String getHeader(String name) {
        Objects.requireNonNull(name);
        List values = (List)((Map)this.lazyMap.get()).get(name.toLowerCase());
        if (values == null) {
            return null;
        }
        return (String)values.get(0);
    }

    public long getLongHeader(String name, long defaultValue) {
        String firstHeader = this.getHeader(name);
        if (firstHeader == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(firstHeader.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public Charset getCharset(Charset defaultCharset) {
        String[] items;
        String contentType = this.getHeader("Content-Type");
        if (contentType == null) {
            return defaultCharset;
        }
        for (String item : items = contentType.split(";")) {
            String key;
            int idx;
            if ((item = item.trim()).isEmpty() || (idx = item.indexOf(61)) < 0 || !(key = item.substring(0, idx).trim()).equalsIgnoreCase("charset")) continue;
            try {
                return Charset.forName(item.substring(idx + 1).trim());
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                return defaultCharset;
            }
        }
        return defaultCharset;
    }

    @Deprecated
    public @Nullable Charset getCharset() {
        return this.getCharset(null);
    }
}

