/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.bouncycastle.jsse.provider.AlgorithmDecomposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class JcaAlgorithmDecomposer
implements AlgorithmDecomposer {
    private static final Pattern PATTERN = Pattern.compile("with|and|(?<!padd)in", 2);
    static final JcaAlgorithmDecomposer INSTANCE_JCA = new JcaAlgorithmDecomposer();

    JcaAlgorithmDecomposer() {
    }

    @Override
    public Set<String> decompose(String string) {
        if (string.indexOf(47) < 0) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : string.split("/")) {
            if (string2.length() <= 0) continue;
            for (String string3 : PATTERN.split(string2)) {
                if (string3.length() <= 0) continue;
                hashSet.add(string3);
            }
        }
        JcaAlgorithmDecomposer.ensureBothIfEither(hashSet, "SHA1", "SHA-1");
        JcaAlgorithmDecomposer.ensureBothIfEither(hashSet, "SHA224", "SHA-224");
        JcaAlgorithmDecomposer.ensureBothIfEither(hashSet, "SHA256", "SHA-256");
        JcaAlgorithmDecomposer.ensureBothIfEither(hashSet, "SHA384", "SHA-384");
        JcaAlgorithmDecomposer.ensureBothIfEither(hashSet, "SHA512", "SHA-512");
        return hashSet;
    }

    private static void ensureBothIfEither(Set<String> set, String string, String string2) {
        boolean bl;
        boolean bl2 = set.contains(string);
        if (bl2 ^ (bl = set.contains(string2))) {
            set.add(bl2 ? string2 : string);
        }
    }
}

