/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.Collection;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;

class DelegatingRepositorySystem
implements RepositorySystem {
    private final RepositorySystem delegate;
    private CollectResult collectResult;

    public DelegatingRepositorySystem(RepositorySystem repositorySystem) {
        this.delegate = repositorySystem;
    }

    public CollectResult getCollectResult() {
        return this.collectResult;
    }

    public CollectResult collectDependencies(final RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        this.collectResult = this.delegate.collectDependencies(session, request);
        final DependencyNode root = this.collectResult.getRoot();
        root.accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                if (root != node) {
                    try {
                        ArtifactResult resolveArtifact = DelegatingRepositorySystem.this.resolveArtifact(session, new ArtifactRequest(node));
                        node.setArtifact(resolveArtifact.getArtifact());
                    }
                    catch (ArtifactResolutionException artifactResolutionException) {
                        // empty catch block
                    }
                }
                return true;
            }

            public boolean visitLeave(DependencyNode dependencyNode) {
                return true;
            }
        }));
        return this.collectResult;
    }

    public DeployResult deploy(RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        return this.delegate.deploy(session, request);
    }

    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        return this.delegate.install(session, request);
    }

    public RemoteRepository newDeploymentRepository(RepositorySystemSession session, RemoteRepository repository) {
        return this.delegate.newDeploymentRepository(session, repository);
    }

    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository localRepository) {
        return this.delegate.newLocalRepositoryManager(session, localRepository);
    }

    public List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session, List<RemoteRepository> repositories) {
        return this.delegate.newResolutionRepositories(session, repositories);
    }

    public SyncContext newSyncContext(RepositorySystemSession session, boolean shared) {
        return this.delegate.newSyncContext(session, shared);
    }

    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        return this.delegate.readArtifactDescriptor(null, request);
    }

    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        return this.delegate.resolveArtifact(session, request);
    }

    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        return this.delegate.resolveArtifacts(session, requests);
    }

    public DependencyResult resolveDependencies(RepositorySystemSession session, DependencyRequest request) throws DependencyResolutionException {
        return this.delegate.resolveDependencies(session, request);
    }

    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        return this.delegate.resolveMetadata(session, requests);
    }

    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        return this.delegate.resolveVersion(session, request);
    }

    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        return this.delegate.resolveVersionRange(session, request);
    }
}

