/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;

public class HtmlUnitMouse
implements Mouse {
    private final HtmlUnitDriver parent;
    private final HtmlUnitKeyboard keyboard;

    public HtmlUnitMouse(HtmlUnitDriver parent, HtmlUnitKeyboard keyboard) {
        this.parent = parent;
        this.keyboard = keyboard;
    }

    public void click(WebElement onElement) {
        onElement.click();
    }

    public void click(HtmlElement element) {
        try {
            if (this.parent.isJavascriptEnabled()) {
                if (!(element instanceof HtmlInput)) {
                    element.focus();
                }
                element.mouseOver();
                element.mouseMove();
            }
            element.click(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed());
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (ScriptException e) {
            System.out.println(e.getMessage());
        }
    }

    public void doubleClick(WebElement onElement) {
        HtmlUnitWebElement htmlElem = (HtmlUnitWebElement)onElement;
        htmlElem.doubleClick();
    }

    public void doubleClick(HtmlElement element) {
        try {
            element.dblClick(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void contextClick(WebElement onElement) {
        HtmlUnitWebElement htmlElem = (HtmlUnitWebElement)onElement;
        htmlElem.mouseContextClick();
    }

    public void contextClick(HtmlElement element) {
        element.rightClick(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed());
    }

    public void mouseDown(WebElement onElement) {
        HtmlUnitWebElement htmlElem = (HtmlUnitWebElement)onElement;
        htmlElem.mouseDown();
    }

    public void mouseDown(HtmlElement element) {
        element.mouseDown(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
    }

    public void mouseUp(WebElement onElement) {
        HtmlUnitWebElement htmlElem = (HtmlUnitWebElement)onElement;
        htmlElem.mouseUp();
    }

    public void mouseUp(HtmlElement element) {
        element.mouseUp(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
    }

    public void mouseMove(WebElement toElement) {
        HtmlUnitWebElement htmlElem = (HtmlUnitWebElement)toElement;
        htmlElem.moveToHere();
    }

    public void mouseMove(HtmlElement element) {
        element.mouseMove(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
        element.mouseOver(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
    }

    public void mouseMove(WebElement toElement, long xOffset, long yOffset) {
        throw new UnsupportedOperationException("Moving to arbitrary X,Y coordinates not supported.");
    }
}

