/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;

public class HttpCommandExecutor
implements CommandExecutor {
    private final String remotePath;
    private Map<String, CommandInfo> nameToUrl;
    private HttpClient client;

    public HttpCommandExecutor(URL addressOfRemoteServer) {
        URI uri;
        if (addressOfRemoteServer == null) {
            String remoteServer = System.getProperty("webdriver.remote.server");
            if (remoteServer != null) {
                try {
                    addressOfRemoteServer = new URL(remoteServer);
                }
                catch (MalformedURLException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
            if (addressOfRemoteServer == null) {
                throw new IllegalArgumentException("You must specify a remote address to connect to");
            }
        }
        this.remotePath = addressOfRemoteServer.getPath();
        try {
            uri = new URI(addressOfRemoteServer.toString(), false);
        }
        catch (URIException e) {
            throw new WebDriverException((Throwable)e);
        }
        this.client = new HttpClient();
        this.client.getHostConfiguration().setHost(uri);
        this.nameToUrl = ImmutableMap.builder().put((Object)"newSession", (Object)HttpCommandExecutor.post("/session")).put((Object)"quit", (Object)HttpCommandExecutor.delete("/session/:sessionId")).put((Object)"getCurrentWindowHandle", (Object)HttpCommandExecutor.get("/session/:sessionId/window_handle")).put((Object)"getWindowHandles", (Object)HttpCommandExecutor.get("/session/:sessionId/window_handles")).put((Object)"get", (Object)HttpCommandExecutor.post("/session/:sessionId/url")).put((Object)"goForward", (Object)HttpCommandExecutor.post("/session/:sessionId/forward")).put((Object)"goBack", (Object)HttpCommandExecutor.post("/session/:sessionId/back")).put((Object)"refresh", (Object)HttpCommandExecutor.post("/session/:sessionId/refresh")).put((Object)"executeScript", (Object)HttpCommandExecutor.post("/session/:sessionId/execute")).put((Object)"getCurrentUrl", (Object)HttpCommandExecutor.get("/session/:sessionId/url")).put((Object)"getTitle", (Object)HttpCommandExecutor.get("/session/:sessionId/title")).put((Object)"getPageSource", (Object)HttpCommandExecutor.get("/session/:sessionId/source")).put((Object)"screenshot", (Object)HttpCommandExecutor.get("/session/:sessionId/screenshot")).put((Object)"setBrowserVisible", (Object)HttpCommandExecutor.post("/session/:sessionId/visible")).put((Object)"isBrowserVisible", (Object)HttpCommandExecutor.get("/session/:sessionId/visible")).put((Object)"findElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element")).put((Object)"findElements", (Object)HttpCommandExecutor.post("/session/:sessionId/elements")).put((Object)"getActiveElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/active")).put((Object)"findChildElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/element")).put((Object)"findChildElements", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/elements")).put((Object)"clickElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/click")).put((Object)"clearElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/clear")).put((Object)"submitElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/submit")).put((Object)"getElementText", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/text")).put((Object)"sendKeysToElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/value")).put((Object)"getElementValue", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/value")).put((Object)"getElementTagName", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/name")).put((Object)"isElementSelected", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/selected")).put((Object)"setElementSelected", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/selected")).put((Object)"toggleElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/toggle")).put((Object)"isElementEnabled", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/enabled")).put((Object)"isElementDisplayed", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/displayed")).put((Object)"hoverOverElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/hover")).put((Object)"getElementLocation", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/location")).put((Object)"getElementLocationOnceScrolledIntoView", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/location_in_view")).put((Object)"getElementSize", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/size")).put((Object)"getElementAttribute", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/attribute/:name")).put((Object)"elementEquals", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/equals/:other")).put((Object)"getCookies", (Object)HttpCommandExecutor.get("/session/:sessionId/cookie")).put((Object)"addCookie", (Object)HttpCommandExecutor.post("/session/:sessionId/cookie")).put((Object)"deleteAllCookies", (Object)HttpCommandExecutor.delete("/session/:sessionId/cookie")).put((Object)"deleteCookie", (Object)HttpCommandExecutor.delete("/session/:sessionId/cookie/:name")).put((Object)"switchToFrame", (Object)HttpCommandExecutor.post("/session/:sessionId/frame")).put((Object)"switchToWindow", (Object)HttpCommandExecutor.post("/session/:sessionId/window")).put((Object)"close", (Object)HttpCommandExecutor.delete("/session/:sessionId/window")).put((Object)"dragElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/drag")).put((Object)"getSpeed", (Object)HttpCommandExecutor.get("/session/:sessionId/speed")).put((Object)"setSpeed", (Object)HttpCommandExecutor.post("/session/:sessionId/speed")).put((Object)"getElementValueOfCssProperty", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/css/:propertyName")).put((Object)"implicitlyWait", (Object)HttpCommandExecutor.post("/session/:sessionId/timeouts/implicit_wait")).put((Object)"executeSQL", (Object)HttpCommandExecutor.post("/session/:sessionId/execute_sql")).put((Object)"getLocation", (Object)HttpCommandExecutor.get("/session/:sessionId/location")).put((Object)"setLocation", (Object)HttpCommandExecutor.post("/session/:sessionId/location")).put((Object)"getAppCache", (Object)HttpCommandExecutor.get("/session/:sessionId/application_cache")).put((Object)"getStatus", (Object)HttpCommandExecutor.get("/session/:sessionId/application_cache/status")).put((Object)"isBrowserOnline", (Object)HttpCommandExecutor.get("/session/:sessionId/browser_connection")).put((Object)"setBrowserOnline", (Object)HttpCommandExecutor.post("/session/:sessionId/browser_connection")).put((Object)"getLocalStorageItem", (Object)HttpCommandExecutor.get("/session/:sessionId/local_storage/:key")).put((Object)"removeLocalStorageItem", (Object)HttpCommandExecutor.delete("/session/:sessionId/local_storage/:key")).put((Object)"getLocalStorageKeys", (Object)HttpCommandExecutor.get("/session/:sessionId/local_storage")).put((Object)"setLocalStorageItem", (Object)HttpCommandExecutor.post("/session/:sessionId/local_storage")).put((Object)"clearLocalStorage", (Object)HttpCommandExecutor.delete("/session/:sessionId/local_storage")).put((Object)"getLocalStorageSize", (Object)HttpCommandExecutor.get("/session/:sessionId/local_storage/size")).put((Object)"getSessionStorageItem", (Object)HttpCommandExecutor.get("/session/:sessionId/session_storage/:key")).put((Object)"removeSessionStorageItem", (Object)HttpCommandExecutor.delete("/session/:sessionId/session_storage/:key")).put((Object)"getSessionStorageKey", (Object)HttpCommandExecutor.get("/session/:sessionId/session_storage")).put((Object)"setSessionStorageItem", (Object)HttpCommandExecutor.post("/session/:sessionId/session_storage")).put((Object)"clearSessionStorage", (Object)HttpCommandExecutor.delete("/session/:sessionId/session_storage")).put((Object)"getSessionStorageSize", (Object)HttpCommandExecutor.get("/session/:sessionId/session_storage/size")).build();
    }

    public URL getAddressOfRemoteServer() {
        try {
            return new URL(this.client.getHostConfiguration().getHostURL());
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public Response execute(Command command) throws Exception {
        CommandInfo info = this.nameToUrl.get(command.getName());
        HttpMethod httpMethod = info.getMethod(this.remotePath, command);
        httpMethod.addRequestHeader("Accept", "application/json, image/png");
        String payload = new BeanToJsonConverter().convert((Object)command.getParameters());
        if (httpMethod instanceof PostMethod) {
            ((PostMethod)httpMethod).setRequestEntity((RequestEntity)new StringRequestEntity(payload, "application/json", "UTF-8"));
        }
        this.client.executeMethod(httpMethod);
        if (this.isRedirect(httpMethod)) {
            Header newLocation = httpMethod.getResponseHeader("location");
            httpMethod = new GetMethod(newLocation.getValue());
            httpMethod.setFollowRedirects(true);
            httpMethod.addRequestHeader("Accept", "application/json, image/png");
            this.client.executeMethod(httpMethod);
        }
        return this.createResponse(httpMethod);
    }

    private Response createResponse(HttpMethod httpMethod) throws Exception {
        Response response;
        Header header = httpMethod.getResponseHeader("Content-Type");
        if (header != null && header.getValue().startsWith("application/json")) {
            response = (Response)new JsonToBeanConverter().convert(Response.class, (Object)httpMethod.getResponseBodyAsString());
        } else {
            int nextSlash;
            response = new Response();
            if (header != null && header.getValue().startsWith("image/png")) {
                response.setValue((Object)httpMethod.getResponseBody());
            } else {
                response.setValue((Object)httpMethod.getResponseBodyAsString());
            }
            String uri = httpMethod.getURI().toString();
            int sessionIndex = uri.indexOf("/session/");
            if (sessionIndex != -1 && (nextSlash = uri.indexOf("/", sessionIndex += "/session/".length())) != -1) {
                response.setSessionId(uri.substring(sessionIndex, nextSlash));
            }
        }
        if (httpMethod.getStatusCode() <= 199 || httpMethod.getStatusCode() >= 300) {
            if (httpMethod.getStatusCode() > 399 && httpMethod.getStatusCode() < 500) {
                response.setStatus(9);
            } else if (httpMethod.getStatusCode() > 499 && httpMethod.getStatusCode() < 600) {
                if (response.getStatus() == 0) {
                    response.setStatus(13);
                }
            } else {
                response.setStatus(13);
            }
        }
        if (response.getValue() instanceof String) {
            response.setValue((Object)((String)response.getValue()).replace("\r\n", "\n"));
        }
        return response;
    }

    private boolean isRedirect(HttpMethod httpMethod) {
        int code = httpMethod.getStatusCode();
        return (code == 301 || code == 302 || code == 303 || code == 307) && httpMethod.getResponseHeader("location") != null;
    }

    private static CommandInfo get(String url) {
        return new CommandInfo(url, HttpVerb.GET);
    }

    private static CommandInfo post(String url) {
        return new CommandInfo(url, HttpVerb.POST);
    }

    private static CommandInfo delete(String url) {
        return new CommandInfo(url, HttpVerb.DELETE);
    }

    private static class CommandInfo {
        private final String url;
        private final HttpVerb verb;

        public CommandInfo(String url, HttpVerb verb) {
            this.url = url;
            this.verb = verb;
        }

        public HttpMethod getMethod(String base, Command command) {
            StringBuilder urlBuilder = new StringBuilder(base);
            for (String part : this.url.split("/")) {
                if (part.length() == 0) continue;
                urlBuilder.append("/");
                if (part.startsWith(":")) {
                    String value = this.get(part.substring(1), command);
                    if (value == null) continue;
                    urlBuilder.append(this.get(part.substring(1), command));
                    continue;
                }
                urlBuilder.append(part);
            }
            return this.verb.createMethod(urlBuilder.toString());
        }

        private String get(String propertyName, Command command) {
            if ("sessionId".equals(propertyName)) {
                return command.getSessionId().toString();
            }
            Object value = command.getParameters().get(propertyName);
            if (value != null) {
                try {
                    return URLEncoder.encode(String.valueOf(value), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return String.valueOf(value);
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HttpVerb {
        GET{

            public HttpMethod createMethod(String url) {
                GetMethod getMethod = new GetMethod(url);
                getMethod.setFollowRedirects(true);
                return getMethod;
            }
        }
        ,
        POST{

            public HttpMethod createMethod(String url) {
                return new PostMethod(url);
            }
        }
        ,
        DELETE{

            public HttpMethod createMethod(String url) {
                return new DeleteMethod(url);
            }
        };


        public abstract HttpMethod createMethod(String var1);
    }
}

