/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.bidi.network.FetchTimingInfo;
import org.openqa.selenium.bidi.network.Header;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class RequestData {
    private final String requestId;
    private final String url;
    private final String method;
    private final List<Header> headers;
    private final List<Cookie> cookies;
    private final long headersSize;
    private final FetchTimingInfo timings;

    public RequestData(String requestId, String url, String method, List<Header> headers, List<Cookie> cookies, long headersSize, FetchTimingInfo timings) {
        this.requestId = requestId;
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.cookies = cookies;
        this.headersSize = headersSize;
        this.timings = timings;
    }

    public static RequestData fromJson(JsonInput input) {
        String requestId = null;
        String url = null;
        String method = null;
        List<Header> headers = new ArrayList<Header>();
        List<Object> cookies = new ArrayList<Cookie>();
        long headersSize = 0L;
        FetchTimingInfo timings = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "request": {
                    requestId = (String)input.read(String.class);
                    continue block18;
                }
                case "url": {
                    url = (String)input.read(String.class);
                    continue block18;
                }
                case "method": {
                    method = (String)input.read(String.class);
                    continue block18;
                }
                case "headers": {
                    headers = (List)input.read(new TypeToken<List<Header>>(){}.getType());
                    continue block18;
                }
                case "cookies": {
                    cookies = (List)input.read(new TypeToken<List<Cookie>>(){}.getType());
                    continue block18;
                }
                case "headersSize": {
                    headersSize = (Long)input.read(Long.class);
                    continue block18;
                }
                case "timings": {
                    timings = (FetchTimingInfo)input.read(FetchTimingInfo.class);
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestData(requestId, url, method, headers, cookies, headersSize, timings);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Long getHeadersSize() {
        return this.headersSize;
    }

    public FetchTimingInfo getTimings() {
        return this.timings;
    }
}

