/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.safari.HasPermissions;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasPermissions
implements AugmenterProvider<HasPermissions>,
AdditionalHttpCommands {
    public static final String GET_PERMISSIONS = "getPermissions";
    public static final String SET_PERMISSIONS = "setPermissions";
    private static final Map<String, CommandInfo> COMMANDS = Map.of("getPermissions", new CommandInfo("/session/:sessionId/apple/permissions", HttpMethod.GET), "setPermissions", new CommandInfo("/session/:sessionId/apple/permissions", HttpMethod.POST));

    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    public Predicate<Capabilities> isApplicable() {
        return caps -> "Safari".equals(caps.getBrowserName());
    }

    public Class<HasPermissions> getDescribedInterface() {
        return HasPermissions.class;
    }

    public HasPermissions getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasPermissions(){

            @Override
            public void setPermissions(String permission, boolean value) {
                executeMethod.execute(AddHasPermissions.SET_PERMISSIONS, Map.of("permissions", Map.of(permission, value)));
            }

            @Override
            public Map<String, Boolean> getPermissions() {
                Map results = (Map)executeMethod.execute(AddHasPermissions.GET_PERMISSIONS, null);
                return (Map)results.get("permissions");
            }
        };
    }
}

