/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mobile;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mobile.device.DeviceHandlerMethodArgumentResolver;
import org.springframework.mobile.device.DeviceResolverHandlerInterceptor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={DeviceResolverHandlerInterceptor.class, DeviceHandlerMethodArgumentResolver.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class DeviceResolverAutoConfiguration {

    @Configuration
    @ConditionalOnWebApplication
    protected static class DeviceResolverMvcConfiguration
    extends WebMvcConfigurerAdapter {
        @Autowired
        private DeviceResolverHandlerInterceptor deviceResolverHandlerInterceptor;

        protected DeviceResolverMvcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={DeviceResolverHandlerInterceptor.class})
        public DeviceResolverHandlerInterceptor deviceResolverHandlerInterceptor() {
            return new DeviceResolverHandlerInterceptor();
        }

        @Bean
        public DeviceHandlerMethodArgumentResolver deviceHandlerMethodArgumentResolver() {
            return new DeviceHandlerMethodArgumentResolver();
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.deviceResolverHandlerInterceptor);
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add((HandlerMethodArgumentResolver)this.deviceHandlerMethodArgumentResolver());
        }
    }
}

