/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.reactor.netty.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.reactor.netty.autoconfigure.ReactorNettyProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ReactorResourceFactory;

public final class ReactorNettyConfigurations {
    private ReactorNettyConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={ReactorNettyProperties.class})
    public static class ReactorResourceFactoryConfiguration {
        @Bean
        @ConditionalOnMissingBean
        ReactorResourceFactory reactorResourceFactory(ReactorNettyProperties configurationProperties) {
            ReactorResourceFactory reactorResourceFactory = new ReactorResourceFactory();
            if (configurationProperties.getShutdownQuietPeriod() != null) {
                reactorResourceFactory.setShutdownQuietPeriod(configurationProperties.getShutdownQuietPeriod());
            }
            return reactorResourceFactory;
        }
    }
}

