/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource.config;

import java.io.IOException;
import org.springframework.cloud.alibaba.sentinel.datasource.config.AbstractDataSourceProperties;
import org.springframework.cloud.alibaba.sentinel.datasource.factorybean.FileRefreshableDataSourceFactoryBean;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class FileDataSourceProperties
extends AbstractDataSourceProperties {
    private String file;
    private String charset = "utf-8";
    private long recommendRefreshMs = 3000L;
    private int bufSize = 0x100000;

    public FileDataSourceProperties() {
        super(FileRefreshableDataSourceFactoryBean.class.getName());
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public long getRecommendRefreshMs() {
        return this.recommendRefreshMs;
    }

    public void setRecommendRefreshMs(long recommendRefreshMs) {
        this.recommendRefreshMs = recommendRefreshMs;
    }

    public int getBufSize() {
        return this.bufSize;
    }

    public void setBufSize(int bufSize) {
        this.bufSize = bufSize;
    }

    @Override
    public void preCheck() {
        super.preCheck();
        try {
            this.setFile(ResourceUtils.getFile((String)StringUtils.trimAllWhitespace((String)this.getFile())).getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("[Sentinel Starter]  handle file [" + this.getFile() + "] error: " + e.getMessage(), e);
        }
    }
}

