/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.jodah.typetools.TypeResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public final class FunctionTypeUtils {
    private static Log logger = LogFactory.getLog(FunctionTypeUtils.class);

    private FunctionTypeUtils() {
    }

    public static boolean isTypeCollection(Type type) {
        if (Collection.class.isAssignableFrom(FunctionTypeUtils.getRawType(type))) {
            return true;
        }
        Class rawType = (type = FunctionTypeUtils.getGenericType(type)) instanceof ParameterizedType ? FunctionTypeUtils.getRawType(type) : (Class)type;
        return Collection.class.isAssignableFrom(rawType);
    }

    public static boolean isTypeArray(Type type) {
        return FunctionTypeUtils.getRawType(type).isArray();
    }

    public static Type getGenericType(Type type) {
        if (FunctionTypeUtils.isPublisher(type) || FunctionTypeUtils.isMessage(type)) {
            type = FunctionTypeUtils.getImmediateGenericType(type, 0);
        }
        return TypeResolver.reify((Type)(type instanceof GenericArrayType ? type : TypeResolver.reify((Type)type)));
    }

    public static Class<?> getRawType(Type type) {
        return type != null ? TypeResolver.resolveRawClass((Type)(type instanceof GenericArrayType ? type : TypeResolver.reify((Type)type)), null) : null;
    }

    public static Method discoverFunctionalMethod(Class<?> pojoFunctionClass) {
        if (Supplier.class.isAssignableFrom(pojoFunctionClass)) {
            return Stream.of(ReflectionUtils.getDeclaredMethods(pojoFunctionClass)).filter(m -> !m.isSynthetic() && m.getName().equals("get")).findFirst().get();
        }
        if (Consumer.class.isAssignableFrom(pojoFunctionClass) || BiConsumer.class.isAssignableFrom(pojoFunctionClass)) {
            return Stream.of(ReflectionUtils.getDeclaredMethods(pojoFunctionClass)).filter(m -> !m.isSynthetic() && m.getName().equals("accept")).findFirst().get();
        }
        if (Function.class.isAssignableFrom(pojoFunctionClass) || BiFunction.class.isAssignableFrom(pojoFunctionClass)) {
            return Stream.of(ReflectionUtils.getDeclaredMethods(pojoFunctionClass)).filter(m -> !m.isSynthetic() && m.getName().equals("apply")).findFirst().get();
        }
        ArrayList methods = new ArrayList();
        ReflectionUtils.doWithMethods(pojoFunctionClass, method -> {
            if (method.getDeclaringClass() == pojoFunctionClass) {
                methods.add(method);
            }
        }, method -> !method.getDeclaringClass().isAssignableFrom(Object.class) && !method.isSynthetic() && !method.isBridge() && !method.isVarArgs());
        Assert.isTrue((methods.size() == 1 ? 1 : 0) != 0, (String)("Discovered " + methods.size() + " methods that would qualify as 'functional' - " + methods + ".\n Class '" + pojoFunctionClass + "' is not a FunctionalInterface."));
        return (Method)methods.get(0);
    }

    public static Type discoverFunctionTypeFromClass(Class<?> functionalClass) {
        Assert.isTrue((boolean)FunctionTypeUtils.isFunctional(functionalClass), (String)"Type must be one of Supplier, Function or Consumer");
        if (Function.class.isAssignableFrom(functionalClass)) {
            for (Type superInterface : functionalClass.getGenericInterfaces()) {
                if (superInterface == null || superInterface.equals(Object.class) || !superInterface.toString().contains("KStream") || !ResolvableType.forType((Type)superInterface).getGeneric(new int[]{1}).isArray()) continue;
                return null;
            }
            return TypeResolver.reify(Function.class, functionalClass);
        }
        if (Consumer.class.isAssignableFrom(functionalClass)) {
            return TypeResolver.reify(Consumer.class, functionalClass);
        }
        if (Supplier.class.isAssignableFrom(functionalClass)) {
            return TypeResolver.reify(Supplier.class, functionalClass);
        }
        return null;
    }

    public static Type discoverFunctionTypeFromFunctionMethod(Method functionMethod) {
        Assert.isTrue((functionMethod.getName().equals("apply") || functionMethod.getName().equals("accept") || functionMethod.getName().equals("get") ? 1 : 0) != 0, (String)("Only Supplier, Function or Consumer supported at the moment. Was " + functionMethod.getDeclaringClass()));
        if (functionMethod.getName().equals("apply")) {
            return ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionMethod, (int)0), ResolvableType.forMethodReturnType((Method)functionMethod)}).getType();
        }
        if (functionMethod.getName().equals("accept")) {
            return ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionMethod, (int)0)}).getType();
        }
        return ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodReturnType((Method)functionMethod)}).getType();
    }

    public static int getInputCount(Type functionType) {
        Type inputType;
        int inputCount;
        FunctionTypeUtils.assertSupportedTypes(functionType);
        int n = inputCount = FunctionTypeUtils.isSupplier(functionType) ? 0 : 1;
        if (functionType instanceof ParameterizedType && !FunctionTypeUtils.isSupplier(functionType) && FunctionTypeUtils.isMulti(inputType = ((ParameterizedType)functionType).getActualTypeArguments()[0])) {
            inputCount = ((ParameterizedType)inputType).getActualTypeArguments().length;
        }
        return inputCount;
    }

    public static int getOutputCount(Type functionType) {
        Type outputType;
        int outputCount;
        FunctionTypeUtils.assertSupportedTypes(functionType);
        int n = outputCount = FunctionTypeUtils.isConsumer(functionType) ? 0 : 1;
        if (functionType instanceof ParameterizedType && !FunctionTypeUtils.isConsumer(functionType) && FunctionTypeUtils.isMulti(outputType = ((ParameterizedType)functionType).getActualTypeArguments()[FunctionTypeUtils.isSupplier(functionType) ? 0 : 1])) {
            outputCount = ((ParameterizedType)outputType).getActualTypeArguments().length;
        }
        return outputCount;
    }

    public static Type getInputType(Type functionType) {
        if (FunctionTypeUtils.isSupplier(functionType)) {
            logger.debug((Object)"Supplier does not have input type, returning null as input type.");
            return null;
        }
        FunctionTypeUtils.assertSupportedTypes(functionType);
        if (functionType instanceof Class) {
            functionType = Function.class.isAssignableFrom((Class)functionType) ? TypeResolver.reify(Function.class, (Class)((Class)functionType)) : TypeResolver.reify(Consumer.class, (Class)((Class)functionType));
        }
        Class<Object> inputType = functionType instanceof ParameterizedType ? ((ParameterizedType)functionType).getActualTypeArguments()[0] : Object.class;
        return inputType;
    }

    public static Type discoverFunctionType(Object function, String functionName, GenericApplicationContext applicationContext) {
        String beanDefinitionName;
        if (function instanceof RoutingFunction) {
            return FunctionType.of(FunctionContextUtils.findType(applicationContext.getBeanFactory(), functionName)).getType();
        }
        if (function instanceof FunctionRegistration) {
            return ((FunctionRegistration)function).getType().getType();
        }
        if (applicationContext.containsBean(functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX)) {
            FunctionRegistration fr = (FunctionRegistration)applicationContext.getBean(functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX, FunctionRegistration.class);
            return fr.getType().getType();
        }
        boolean beanDefinitionExists = false;
        String functionBeanDefinitionName = FunctionTypeUtils.discoverDefinitionName(functionName, applicationContext);
        beanDefinitionExists = applicationContext.getBeanFactory().containsBeanDefinition(functionBeanDefinitionName);
        if (applicationContext.containsBean("&" + functionName)) {
            Class objectType = ((FactoryBean)applicationContext.getBean("&" + functionName, FactoryBean.class)).getObjectType();
            return FunctionTypeUtils.discoverFunctionTypeFromClass(objectType);
        }
        Type type = FunctionTypeUtils.discoverFunctionTypeFromClass(function.getClass());
        if (beanDefinitionExists) {
            Type t = FunctionTypeUtils.getImmediateGenericType(type, 0);
            if (t == null || t == Object.class) {
                type = FunctionType.of(FunctionContextUtils.findType(applicationContext.getBeanFactory(), functionBeanDefinitionName)).getType();
            }
        } else if (!(type instanceof ParameterizedType) && StringUtils.hasText((String)(beanDefinitionName = FunctionTypeUtils.discoverBeanDefinitionNameByQualifier((ListableBeanFactory)applicationContext.getBeanFactory(), functionName)))) {
            type = FunctionType.of(FunctionContextUtils.findType(applicationContext.getBeanFactory(), beanDefinitionName)).getType();
        }
        return type;
    }

    public static String discoverBeanDefinitionNameByQualifier(ListableBeanFactory beanFactory, String qualifier) {
        Map beanMap = BeanFactoryAnnotationUtils.qualifiedBeansOfType((ListableBeanFactory)beanFactory, Object.class, (String)qualifier);
        if (!CollectionUtils.isEmpty((Map)beanMap) && beanMap.size() == 1) {
            return (String)beanMap.keySet().iterator().next();
        }
        return null;
    }

    public static Type getOutputType(Type functionType) {
        FunctionTypeUtils.assertSupportedTypes(functionType);
        if (FunctionTypeUtils.isConsumer(functionType)) {
            logger.debug((Object)"Consumer does not have output type, returning null as output type.");
            return null;
        }
        if (functionType instanceof Class) {
            Type type = functionType = Function.class.isAssignableFrom((Class)functionType) ? TypeResolver.reify(Function.class, (Class)((Class)functionType)) : TypeResolver.reify(Supplier.class, (Class)((Class)functionType));
        }
        Class<Object> outputType = functionType instanceof ParameterizedType ? (FunctionTypeUtils.isSupplier(functionType) ? ((ParameterizedType)functionType).getActualTypeArguments()[0] : ((ParameterizedType)functionType).getActualTypeArguments()[1]) : Object.class;
        return outputType;
    }

    public static Type getImmediateGenericType(Type type, int index) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        return null;
    }

    public static boolean isPublisher(Type type) {
        return FunctionTypeUtils.isFlux(type) || FunctionTypeUtils.isMono(type);
    }

    public static boolean isFlux(Type type) {
        return TypeResolver.resolveRawClass((Type)type, null) == Flux.class;
    }

    public static boolean isCollectionOfMessage(Type type) {
        if (FunctionTypeUtils.isMessage(type) && FunctionTypeUtils.isTypeCollection(type)) {
            return FunctionTypeUtils.isMessage(FunctionTypeUtils.getImmediateGenericType(type, 0));
        }
        return false;
    }

    public static boolean isMessage(Type type) {
        if (FunctionTypeUtils.isPublisher(type)) {
            type = FunctionTypeUtils.getImmediateGenericType(type, 0);
        }
        if (type instanceof ParameterizedType && !Message.class.isAssignableFrom(TypeResolver.resolveRawClass((Type)type, null))) {
            type = FunctionTypeUtils.getImmediateGenericType(type, 0);
        }
        return Message.class.isAssignableFrom(TypeResolver.resolveRawClass((Type)type, null));
    }

    public static boolean isOutputArray(Type functionType) {
        Type outputType = FunctionTypeUtils.getOutputType(functionType);
        return outputType instanceof GenericArrayType || outputType instanceof Class && ((Class)outputType).isArray();
    }

    public static boolean isSupplier(Type type) {
        return FunctionTypeUtils.isOfType(type, Supplier.class);
    }

    public static boolean isFunction(Type type) {
        return FunctionTypeUtils.isOfType(type, Function.class);
    }

    public static boolean isConsumer(Type type) {
        return FunctionTypeUtils.isOfType(type, Consumer.class);
    }

    public static boolean isMono(Type type) {
        return (type = FunctionTypeUtils.extractReactiveType(type)) == null ? false : type.getTypeName().startsWith("reactor.core.publisher.Mono");
    }

    public static boolean isMultipleArgumentType(Type type) {
        if (type != null) {
            if (TypeResolver.resolveRawClass((Type)type, null).isArray()) {
                return false;
            }
            Class clazz = TypeResolver.resolveRawClass((Type)TypeResolver.reify((Type)type), null);
            return clazz.getName().startsWith("reactor.util.function.Tuple");
        }
        return false;
    }

    static Type fromFunctionMethod(Method functionalMethod) {
        Type[] parameterTypes = functionalMethod.getGenericParameterTypes();
        Type functionType = null;
        switch (parameterTypes.length) {
            case 0: {
                functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodReturnType((Method)functionalMethod)}).getType();
                break;
            }
            case 1: {
                if (Void.class.isAssignableFrom(functionalMethod.getReturnType())) {
                    functionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionalMethod, (int)0)}).getType();
                    break;
                }
                functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionalMethod, (int)0), ResolvableType.forMethodReturnType((Method)functionalMethod)}).getType();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Functional method: " + functionalMethod + " is not supported");
            }
        }
        return functionType;
    }

    private static boolean isMulti(Type type) {
        return type.getTypeName().startsWith("reactor.util.function.Tuple");
    }

    private static boolean isOfType(Type type, Class<?> cls) {
        if (type instanceof Class) {
            return cls.isAssignableFrom((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return FunctionTypeUtils.isOfType(((ParameterizedType)type).getRawType(), cls);
        }
        return false;
    }

    private static void assertSupportedTypes(Type type) {
        Class candidateType;
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
            Assert.isTrue((boolean)(type instanceof Class), (String)("Must be one of Supplier, Function, Consumer or FunctionRegistration. Was " + type));
        }
        Assert.isTrue((Supplier.class.isAssignableFrom(candidateType = (Class)type) || Function.class.isAssignableFrom(candidateType) || Consumer.class.isAssignableFrom(candidateType) || FunctionRegistration.class.isAssignableFrom(candidateType) || type.getTypeName().startsWith("org.springframework.context.annotation.ConfigurationClassEnhancer") ? 1 : 0) != 0, (String)("Must be one of Supplier, Function, Consumer or FunctionRegistration. Was " + type));
    }

    private static Type extractReactiveType(Type type) {
        if (type instanceof ParameterizedType && FunctionRegistration.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) && (type = FunctionTypeUtils.getImmediateGenericType(type, 0)) instanceof ParameterizedType) {
            type = FunctionTypeUtils.getImmediateGenericType(type, 0);
        }
        return type;
    }

    private static String discoverDefinitionName(String functionDefinition, GenericApplicationContext applicationContext) {
        String[] aliases;
        for (String alias : aliases = applicationContext.getAliases(functionDefinition)) {
            if (!applicationContext.getBeanFactory().containsBeanDefinition(alias)) continue;
            return alias;
        }
        return functionDefinition;
    }

    private static boolean isFunctional(Type type) {
        Class candidateType;
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
            Assert.isTrue((boolean)(type instanceof Class), (String)("Must be one of Supplier, Function, Consumer or FunctionRegistration. Was " + type));
        }
        return Supplier.class.isAssignableFrom(candidateType = (Class)type) || Function.class.isAssignableFrom(candidateType) || Consumer.class.isAssignableFrom(candidateType) || BiFunction.class.isAssignableFrom(candidateType) || BiConsumer.class.isAssignableFrom(candidateType);
    }
}

