/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.turbine.data.AggDataFromCluster;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.handler.PerformanceCriteria;
import com.netflix.turbine.handler.TurbineDataHandler;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import com.netflix.turbine.monitor.cluster.AggregateClusterMonitor;
import com.netflix.turbine.monitor.cluster.ClusterMonitor;
import com.netflix.turbine.monitor.cluster.ClusterMonitorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.turbine.SpringClusterMonitor;

public class SpringAggregatorFactory
implements ClusterMonitorFactory<AggDataFromCluster> {
    private static final Log log = LogFactory.getLog(SpringAggregatorFactory.class);
    private static final DynamicStringProperty aggClusters = DynamicPropertyFactory.getInstance().getStringProperty("turbine.aggregator.clusterConfig", null);
    private TurbineDataHandler<AggDataFromCluster> StaticListener = new TurbineDataHandler<AggDataFromCluster>(){

        public String getName() {
            return "StaticListener_For_Aggregator";
        }

        public void handleData(Collection<AggDataFromCluster> stats) {
        }

        public void handleHostLost(Instance host) {
        }

        public PerformanceCriteria getCriteria() {
            return SpringAggregatorFactory.this.NonCriticalCriteria;
        }
    };
    private PerformanceCriteria NonCriticalCriteria = new PerformanceCriteria(){

        public boolean isCritical() {
            return false;
        }

        public int getMaxQueueSize() {
            return 0;
        }

        public int numThreads() {
            return 0;
        }
    };

    public ClusterMonitor<AggDataFromCluster> getClusterMonitor(String name) {
        TurbineDataMonitor clusterMonitor = AggregateClusterMonitor.AggregatorClusterMonitorConsole.findMonitor(name + "_agg");
        return (ClusterMonitor)clusterMonitor;
    }

    public static TurbineDataMonitor<AggDataFromCluster> findOrRegisterAggregateMonitor(String clusterName) {
        Object clusterMonitor = AggregateClusterMonitor.AggregatorClusterMonitorConsole.findMonitor(clusterName + "_agg");
        if (clusterMonitor == null) {
            log.info((Object)("Could not find monitors: " + AggregateClusterMonitor.AggregatorClusterMonitorConsole.toString()));
            clusterMonitor = new SpringClusterMonitor(clusterName + "_agg", clusterName);
            clusterMonitor = AggregateClusterMonitor.AggregatorClusterMonitorConsole.findOrRegisterMonitor(clusterMonitor);
        }
        return clusterMonitor;
    }

    public void initClusterMonitors() {
        for (String clusterName : this.getClusterNames()) {
            ClusterMonitor clusterMonitor = (ClusterMonitor)SpringAggregatorFactory.findOrRegisterAggregateMonitor(clusterName);
            clusterMonitor.registerListenertoClusterMonitor(this.StaticListener);
            try {
                clusterMonitor.startMonitor();
            }
            catch (Exception ex) {
                log.warn((Object)("Could not init cluster monitor for: " + clusterName));
                clusterMonitor.stopMonitor();
                clusterMonitor.getDispatcher().stopDispatcher();
            }
        }
    }

    private List<String> getClusterNames() {
        ArrayList<String> clusters = new ArrayList<String>();
        String clusterNames = aggClusters.get();
        if (clusterNames == null || clusterNames.trim().length() == 0) {
            clusters.add("default");
        } else {
            String[] parts;
            for (String s : parts = aggClusters.get().split(",")) {
                clusters.add(s);
            }
        }
        return clusters;
    }

    public void shutdownClusterMonitors() {
        for (String clusterName : this.getClusterNames()) {
            ClusterMonitor clusterMonitor = (ClusterMonitor)AggregateClusterMonitor.findOrRegisterAggregateMonitor((String)clusterName);
            clusterMonitor.stopMonitor();
            clusterMonitor.getDispatcher().stopDispatcher();
        }
    }
}

