/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.Assert;

public class KafkaExpressionEvaluatingInterceptor
implements ChannelInterceptor {
    public static final String MESSAGE_KEY_HEADER = "scst_messageKey";
    private final Expression messageKeyExpression;
    private final EvaluationContext evaluationContext;

    public KafkaExpressionEvaluatingInterceptor(Expression messageKeyExpression, EvaluationContext evaluationContext) {
        Assert.notNull((Object)(messageKeyExpression != null ? 1 : 0), (String)"A message key expression is required");
        Assert.notNull((Object)evaluationContext, (String)"the 'evaluationContext' cannot be null");
        this.messageKeyExpression = messageKeyExpression;
        this.evaluationContext = evaluationContext;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        MessageBuilder builder = MessageBuilder.fromMessage(message);
        if (this.messageKeyExpression != null) {
            builder.setHeader(MESSAGE_KEY_HEADER, this.messageKeyExpression.getValue(this.evaluationContext, message));
        }
        return builder.build();
    }
}

