/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.OAuth2RequestValidator;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.approval.ApprovalStore;
import org.springframework.security.oauth2.provider.approval.ApprovalStoreUserApprovalHandler;
import org.springframework.security.oauth2.provider.approval.TokenApprovalStore;
import org.springframework.security.oauth2.provider.approval.TokenStoreUserApprovalHandler;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenGranter;
import org.springframework.security.oauth2.provider.client.InMemoryClientDetailsService;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeTokenGranter;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.implicit.ImplicitGrantService;
import org.springframework.security.oauth2.provider.implicit.ImplicitTokenGranter;
import org.springframework.security.oauth2.provider.implicit.InMemoryImplicitGrantService;
import org.springframework.security.oauth2.provider.password.ResourceOwnerPasswordTokenGranter;
import org.springframework.security.oauth2.provider.refresh.RefreshTokenGranter;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestFactory;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestValidator;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.InMemoryTokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;

public final class AuthorizationServerEndpointsConfigurer {
    private AuthorizationServerTokenServices tokenServices;
    private ConsumerTokenServices consumerTokenServices;
    private AuthorizationCodeServices authorizationCodeServices;
    private ResourceServerTokenServices resourceTokenServices;
    private ImplicitGrantService implicitGrantService = new InMemoryImplicitGrantService();
    private TokenStore tokenStore;
    private TokenEnhancer tokenEnhancer;
    private AccessTokenConverter accessTokenConverter;
    private ApprovalStore approvalStore;
    private TokenGranter tokenGranter;
    private OAuth2RequestFactory requestFactory;
    private OAuth2RequestValidator requestValidator;
    private UserApprovalHandler userApprovalHandler;
    private AuthenticationManager authenticationManager;
    private ClientDetailsService clientDetailsService;
    private Map<String, String> patternMap = new HashMap<String, String>();
    private FrameworkEndpointHandlerMapping frameworkEndpointHandlerMapping;
    private boolean approvalStoreDisabled;

    public AuthorizationServerTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore();
    }

    public TokenEnhancer getTokenEnhancer() {
        return this.tokenEnhancer;
    }

    public AccessTokenConverter getAccessTokenConverter() {
        return this.accessTokenConverter;
    }

    public ApprovalStore getApprovalStore() {
        return this.approvalStore;
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public OAuth2RequestFactory getOAuth2RequestFactory() {
        return this.requestFactory();
    }

    public OAuth2RequestValidator getOAuth2RequestValidator() {
        return this.requestValidator();
    }

    public UserApprovalHandler getUserApprovalHandler() {
        return this.userApprovalHandler();
    }

    public AuthorizationServerEndpointsConfigurer tokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer tokenEnhancer(TokenEnhancer tokenEnhancer) {
        this.tokenEnhancer = tokenEnhancer;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer accessTokenConverter(AccessTokenConverter accessTokenConverter) {
        this.accessTokenConverter = accessTokenConverter;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer tokenServices(AuthorizationServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer userApprovalHandler(UserApprovalHandler approvalHandler) {
        this.userApprovalHandler = approvalHandler;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer approvalStore(ApprovalStore approvalStore) {
        if (this.approvalStoreDisabled) {
            throw new IllegalStateException("ApprovalStore was disabled");
        }
        this.approvalStore = approvalStore;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer approvalStoreDisabled() {
        this.approvalStoreDisabled = true;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer pathMapping(String defaultPath, String customPath) {
        this.patternMap.put(defaultPath, customPath);
        return this;
    }

    public AuthorizationServerEndpointsConfigurer authenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer tokenGranter(TokenGranter tokenGranter) {
        this.tokenGranter = tokenGranter;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer clientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer requestFactory(OAuth2RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer requestValidator(OAuth2RequestValidator requestValidator) {
        this.requestValidator = requestValidator;
        return this;
    }

    public AuthorizationServerEndpointsConfigurer authorizationCodeServices(AuthorizationCodeServices authorizationCodeServices) {
        this.authorizationCodeServices = authorizationCodeServices;
        return this;
    }

    public ConsumerTokenServices getConsumerTokenServices() {
        return this.consumerTokenServices();
    }

    public ResourceServerTokenServices getResourceServerTokenServices() {
        return this.resourceTokenServices();
    }

    public ImplicitGrantService getImplicitGrantService() {
        return this.implicitGrantService;
    }

    public AuthorizationCodeServices getAuthorizationCodeServices() {
        return this.authorizationCodeServices();
    }

    public OAuth2RequestValidator getRequestValidator() {
        return this.requestValidator();
    }

    public TokenGranter getTokenGranter() {
        return this.tokenGranter();
    }

    public FrameworkEndpointHandlerMapping getFrameworkEndpointHandlerMapping() {
        return this.frameworkEndpointHandlerMapping();
    }

    private ResourceServerTokenServices resourceTokenServices() {
        if (this.resourceTokenServices == null) {
            if (this.tokenServices instanceof ResourceServerTokenServices) {
                return (ResourceServerTokenServices)((Object)this.tokenServices);
            }
            this.resourceTokenServices = this.createTokenServices();
        }
        return this.resourceTokenServices;
    }

    private ConsumerTokenServices consumerTokenServices() {
        if (this.consumerTokenServices == null) {
            if (this.tokenServices instanceof ConsumerTokenServices) {
                return (ConsumerTokenServices)((Object)this.tokenServices);
            }
            this.consumerTokenServices = this.createTokenServices();
        }
        return this.consumerTokenServices;
    }

    private AuthorizationServerTokenServices tokenServices() {
        if (this.tokenServices != null) {
            return this.tokenServices;
        }
        this.tokenServices = this.createTokenServices();
        return this.tokenServices;
    }

    private DefaultTokenServices createTokenServices() {
        DefaultTokenServices tokenServices = new DefaultTokenServices();
        tokenServices.setTokenStore(this.tokenStore());
        tokenServices.setSupportRefreshToken(true);
        tokenServices.setClientDetailsService(this.clientDetailsService());
        tokenServices.setTokenEnhancer(this.tokenEnchancer());
        return tokenServices;
    }

    private TokenEnhancer tokenEnchancer() {
        if (this.tokenEnhancer == null && this.accessTokenConverter() instanceof JwtAccessTokenConverter) {
            this.tokenEnhancer = (TokenEnhancer)((Object)this.accessTokenConverter);
        }
        return this.tokenEnhancer;
    }

    private AccessTokenConverter accessTokenConverter() {
        if (this.accessTokenConverter == null) {
            this.accessTokenConverter = new DefaultAccessTokenConverter();
        }
        return this.accessTokenConverter;
    }

    private TokenStore tokenStore() {
        if (this.tokenStore == null) {
            this.tokenStore = this.accessTokenConverter() instanceof JwtAccessTokenConverter ? new JwtTokenStore((JwtAccessTokenConverter)this.accessTokenConverter()) : new InMemoryTokenStore();
        }
        return this.tokenStore;
    }

    private ApprovalStore approvalStore() {
        if (this.approvalStore == null && this.tokenStore() != null && !this.isApprovalStoreDisabled()) {
            TokenApprovalStore tokenApprovalStore = new TokenApprovalStore();
            tokenApprovalStore.setTokenStore(this.tokenStore());
            this.approvalStore = tokenApprovalStore;
        }
        return this.approvalStore;
    }

    private boolean isApprovalStoreDisabled() {
        return this.approvalStoreDisabled || this.tokenStore() instanceof JwtTokenStore;
    }

    private ClientDetailsService clientDetailsService() {
        if (this.clientDetailsService == null) {
            this.clientDetailsService = new InMemoryClientDetailsService();
        }
        return this.clientDetailsService;
    }

    private UserApprovalHandler userApprovalHandler() {
        if (this.userApprovalHandler == null) {
            if (this.approvalStore() != null) {
                ApprovalStoreUserApprovalHandler handler = new ApprovalStoreUserApprovalHandler();
                handler.setApprovalStore(this.approvalStore());
                handler.setRequestFactory(this.requestFactory());
                handler.setClientDetailsService(this.clientDetailsService);
                this.userApprovalHandler = handler;
            } else if (this.tokenStore() != null) {
                TokenStoreUserApprovalHandler userApprovalHandler = new TokenStoreUserApprovalHandler();
                userApprovalHandler.setTokenStore(this.tokenStore());
                userApprovalHandler.setClientDetailsService(this.clientDetailsService());
                userApprovalHandler.setRequestFactory(this.requestFactory());
                this.userApprovalHandler = userApprovalHandler;
            } else {
                throw new IllegalStateException("Either a TokenStore or an ApprovalStore must be provided");
            }
        }
        return this.userApprovalHandler;
    }

    private AuthorizationCodeServices authorizationCodeServices() {
        if (this.authorizationCodeServices == null) {
            this.authorizationCodeServices = new InMemoryAuthorizationCodeServices();
        }
        return this.authorizationCodeServices;
    }

    private OAuth2RequestFactory requestFactory() {
        if (this.requestFactory != null) {
            return this.requestFactory;
        }
        this.requestFactory = new DefaultOAuth2RequestFactory(this.clientDetailsService());
        return this.requestFactory;
    }

    private OAuth2RequestValidator requestValidator() {
        if (this.requestValidator != null) {
            return this.requestValidator;
        }
        this.requestValidator = new DefaultOAuth2RequestValidator();
        return this.requestValidator;
    }

    private TokenGranter tokenGranter() {
        if (this.tokenGranter == null) {
            ClientDetailsService clientDetails = this.clientDetailsService();
            AuthorizationServerTokenServices tokenServices = this.tokenServices();
            AuthorizationCodeServices authorizationCodeServices = this.authorizationCodeServices();
            OAuth2RequestFactory requestFactory = this.requestFactory();
            ArrayList<TokenGranter> tokenGranters = new ArrayList<TokenGranter>();
            tokenGranters.add(new AuthorizationCodeTokenGranter(tokenServices, authorizationCodeServices, clientDetails, requestFactory));
            tokenGranters.add(new RefreshTokenGranter(tokenServices, clientDetails, requestFactory));
            ImplicitTokenGranter implicit = new ImplicitTokenGranter(tokenServices, clientDetails, requestFactory);
            implicit.setImplicitGrantService(this.implicitGrantService);
            tokenGranters.add(implicit);
            tokenGranters.add(new ClientCredentialsTokenGranter(tokenServices, clientDetails, requestFactory));
            if (this.authenticationManager != null) {
                tokenGranters.add(new ResourceOwnerPasswordTokenGranter(this.authenticationManager, tokenServices, clientDetails, requestFactory));
            }
            this.tokenGranter = new CompositeTokenGranter(tokenGranters);
        }
        return this.tokenGranter;
    }

    private FrameworkEndpointHandlerMapping frameworkEndpointHandlerMapping() {
        if (this.frameworkEndpointHandlerMapping == null) {
            this.frameworkEndpointHandlerMapping = new FrameworkEndpointHandlerMapping();
            this.frameworkEndpointHandlerMapping.setMappings(this.patternMap);
        }
        return this.frameworkEndpointHandlerMapping;
    }
}

