/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth2.provider.BaseRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Request;

public class TokenRequest
extends BaseRequest {
    private String grantType;

    protected TokenRequest() {
    }

    public TokenRequest(Map<String, String> requestParameters, String clientId, Collection<String> scope, String grantType) {
        this.setClientId(clientId);
        this.setRequestParameters(requestParameters);
        this.setScope(scope);
        this.grantType = grantType;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @Override
    public void setClientId(String clientId) {
        super.setClientId(clientId);
    }

    @Override
    public void setScope(Collection<String> scope) {
        super.setScope(scope);
    }

    @Override
    public void setRequestParameters(Map<String, String> requestParameters) {
        super.setRequestParameters(requestParameters);
    }

    public OAuth2Request createOAuth2Request(ClientDetails client) {
        Map requestParameters = this.getRequestParameters();
        HashMap<String, String> modifiable = new HashMap<String, String>(requestParameters);
        modifiable.remove("password");
        return new OAuth2Request(modifiable, client.getClientId(), client.getAuthorities(), true, this.getScope(), null, null, null, null);
    }
}

