/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.util.Collection;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.Transient;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;

@Transient
public class JwtAuthenticationToken
extends AbstractOAuth2TokenAuthenticationToken<Jwt> {
    private static final long serialVersionUID = 510L;

    public JwtAuthenticationToken(Jwt jwt) {
        super(jwt);
    }

    public JwtAuthenticationToken(Jwt jwt, Collection<? extends GrantedAuthority> authorities) {
        super(jwt, authorities);
        this.setAuthenticated(true);
    }

    @Override
    public Map<String, Object> getTokenAttributes() {
        return ((Jwt)this.getToken()).getClaims();
    }

    public String getName() {
        return ((Jwt)this.getToken()).getSubject();
    }
}

